@push('styles')
    <script defer src="{{ url('assets/front/new/js/alpine.min.js') }}"></script>

    <!-- TomSelect -->
    <link href="{{ url('assets/front/new/css/tom_select.css') }}" rel="stylesheet">
    <script src="{{ url('assets/front/new/js/tom_select.min.js') }}"></script>
    <style>
        .ts-control,
        .ts-wrapper.single.input-active .ts-control {
            background: #ffffff;
            transition: background-color 0.5s ease, border 0.5s ease;
        }

        .ts-control:hover,
        .ts-wrapper.single.input-active:hover .ts-control {
            background-color: white;
            border: black solid 1px;
        }

        .ts-wrapper.multi .ts-control>div {
            background-color: var(--grayBack);
        }

        .ts-dropdown,
        .ts-control,
        .ts-control input {
            font-size: 14px;
        }

        .form-check-input:hover {
            border-color: rgb(229, 69, 68);
            transition: 0.5s;
            cursor: pointer;
        }
    </style>
@endpush

@push('scripts')
    <script>
        const Toast = Swal.mixin({
            toast: true,
            position: "top-end",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.onmouseenter = Swal.stopTimer;
                toast.onmouseleave = Swal.resumeTimer;
            }
        });
        document.addEventListener('livewire:init', () => {
            Livewire.on('alert', (value) => {
                Toast.fire({
                    icon: value['icon'],
                    title: value['title']
                });
            });

            Livewire.on('resetPage', () => {
                location.reload();
            });
        });
    </script>
@endpush
<div>
    <a href="{{ $banner->link }}" class="banner-box h-auto">
        <img src="{{ url($banner->photo->path) }}" alt="{{ photo_alt($banner, 'photo', 'banner') }}">
    </a>
    <div class="container-xxl">
        <div class="breadcrumb">
            <ul class="breadcrumb-links">
                <li>
                    <a href="{{ route('front.index') }}">{{ read_lang_word('home') }}</a>
                </li>
                <li>
                    <span class="end-item">{{ read_lang_word('title-rfq') }}</span>
                </li>
            </ul>
        </div>
    </div>
    <div class="bg-white py-4">
        <div class="container-xxl" style="max-width: 70vw">
            <div class="section-heading ps-2">
                <div class="section-heading-right-side">
                    <div class="section-heading-title-box start">
                        <h6 class="section-heading-title">{{ read_lang_word('tell-us-what-you-need-find-the-best-matching-suppliers') }}</h6>
                        <p>{{ read_lang_word('more-details-better-matches-faster-responses') }}</p>
                    </div>
                </div>
            </div>
            <div class="rfq-form">
                <form enctype="multipart/form-data" wire:submit.prevent="submit" class="row g-2" onkeydown="if(event.key === 'Enter') event.preventDefault();">
                    @csrf
                    <div class="col-12" wire:ignore x-data="{
                        keywordOptions: @js($initialKeywords),
                        init() {
                            new TomSelect(this.$refs.keywordsInput, {
                                plugins: ['remove_button'],
                                create: true,
                                persist: false,
                                maxItems: 10,
                                delimiter: ',',
                                valueField: 'value',
                                labelField: 'text',
                                searchField: 'text',
                                placeholder: '{{ read_lang_word('enter-a-keyword') }} (eg. Toy, Car, ...)',
                                options: this.keywordOptions.map(item => ({ value: item, text: item })),
                                onChange: (value) => {
                                    @this.set('product_name', value.join(' , '));
                                },
                                onInitialize: function() {
                                    this.setValue(@this.product_name.split(' , '));
                                }
                            });
                        }
                    }">
                        <label for="productName" class="form-label fw-bold ">{{ read_lang_word('product-name') }}: <span class="text-danger">*</span></label>
                        <select x-ref="keywordsInput" multiple></select>
                    </div>
                    @error('product_name')
                        <div class="text-danger small">{{ $message }}</div>
                    @enderror
                    <div class="col-12 col-xl-12">
                        <label for="productCategory" class="form-label fw-bold">{{ read_lang_word('product-category') }}
                            :</label>
                        <div class="select-container @error('product_category')border-danger border-1 @enderror">
                            <select id="productCategory" wire:model.defer="product_category" class="form-select " onchange="toggleCustomInput()">
                                <option value="" selected="">{{ read_lang_word('select-category') }}</option>
                                @foreach ($this->grandchildren as $cat)
                                    <option value="{{ $cat->id }}">{{ read_lang($cat, 'title') }}</option>
                                    @foreach ($cat->children as $child)
                                        <option value="{{ $child->id }}">└─ {{ read_lang($child, 'title') }}</option>
                                        @foreach ($child->children as $grandchild)
                                            <option value="{{ $grandchild->id }}">
                                                ─└─ {{ read_lang($grandchild, 'title') }}</option>
                                        @endforeach
                                    @endforeach
                                @endforeach
                                <option value="other">{{ read_lang_word('other') }}</option>
                            </select>
                            @error('product_category')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        <input type="text" id="customCategory" class="form-control mt-2 @error('product_category_custom') is-invalid @enderror" wire:model.defer="product_category_custom"
                            placeholder="{{ read_lang_word('dont-find-write-your-category') }}" style="display: none;">
                        @error('product_category_custom')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                    </div>


                    <div class="col-md-6 col-xl-6">
                        <label for="requiredQuantity" class="form-label fw-bold">{{ read_lang_word('required-quantity') }}:
                            <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('required_quantity') is-invalid @enderror " id="requiredQuantity" wire:model.defer="required_quantity" required>
                        @error('required_quantity')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6 col-xl-6">
                        <label for="selectUnit" class="form-label fw-bold">{{ read_lang_word('select-unit') }}: <span class="text-danger">*</span></label>
                        <div class="select-container">
                            <select id="selectUnit" wire:model.defer="select_unit" class="form-select" required>
                                <option value="" disabled="" selected="">{{ read_lang_word('unit') }}</option>
                                @foreach ($this->rfqForm as $unit)
                                    @if ($unit->type == 'units')
                                        <option value="{{ read_lang($unit, 'title1') }}">{{ read_lang($unit, 'title1') }}</option>
                                    @endif
                                @endforeach
                            </select>
                        </div>
                        @error('select_unit')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-12">
                        <label for="productDetails" class="form-label fw-bold">{{ read_lang_word('product-details') }}:
                            <span class="text-danger">*</span></label>
                        <textarea class="form-control @error('product_category_custom') is-invalid @enderror" id="productDetails" wire:model.defer="product_details" rows="4" required placeholder="{{ read_lang_word('detailed-description-of-the-product') }}"></textarea>
                        @error('product_details')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-12" x-data="{
                            fileInputs: [],
                            fileNames: {},
                            nextId: 1,
                            addFileInput() {
                                const id = this.nextId++;
                                this.fileInputs.push(id);
                                this.fileNames[id] = '{{ read_lang_word('no-file-chosen') }}';
                                return id;
                            },
                            removeFileInput(id) {
                                const index = this.fileInputs.indexOf(id);
                                if (index !== -1) {
                                    this.fileInputs.splice(index, 1);
                                    delete this.fileNames[id];
                                    const livewireIndex = this.$wire.product_images.findIndex((_, i) => i === index);
                                    if (livewireIndex !== -1) {
                                        this.$wire.product_images.splice(livewireIndex, 1);
                                    }
                                }
                            }
                        }">
                        <label for="productImages" class="form-label fw-bold">{{ read_lang_word('product-images-files') }}:
                            <span class="text-danger">*</span></label>
                        <div class="d-flex align-items-center mb-2">
                            <div class="custom-file-upload flex-grow-1 me-2">
                                <input type="file" id="product_images_initial" class="@error('product_images') is-invalid @enderror" wire:model="product_images"
                                       x-on:change="fileNames['initial'] = $event.target.files[0]?.name || '{{ read_lang_word('no-file-chosen') }}'">
                                <label for="product_images_initial">{{ read_lang_word('product-images-files') }}</label>
                                <span class="file-name" x-text="fileNames['initial']"></span>
                            </div>
                        </div>

                        <template x-for="(id, index) in fileInputs" :key="id">
                            <div class="d-flex align-items-center mb-2">
                                <div class="custom-file-upload flex-grow-1 me-2">
                                    <input type="file" :id="'product_images_' + id" class="@error('product_images') is-invalid @enderror"
                                           wire:model.defer="product_images"
                                           x-on:change="fileNames[id] = $event.target.files[0]?.name || '{{ read_lang_word('no-file-chosen') }}'">
                                    <label :for="'product_images_' + id">{{ read_lang_word('product-images-files') }}</label>
                                    <span class="file-name" x-text="fileNames[id]"></span>
                                </div>
                                <button type="button" class="btn btn-sm btn-danger" x-on:click="removeFileInput(id)">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </div>
                        </template>

                        <div class="d-flex justify-content-between">
                            <label class="form-label">No of Files: 5 - Max Size: 5 MB - Format: .jpg, .png, .docx, .xlsx, .pdf, rar, zip</label>
                            @error('product_images.*')
                            <div class="text-danger small">{{ $message }}</div>
                            @enderror
                            <button type="button" class="btn btn-sm btn-primary mt-2" x-on:click="addFileInput()" x-show="fileInputs.length < 4">
                                <i class="fa fa-plus"></i>
                            </button>
                        </div>
                    </div>

                    <div class="col-12">
                        <label class="form-label fw-bold">{{ read_lang_word('trade-terms') }}: <span class="text-danger">*</span></label>
                        <div>
                            <div class="row g-2">
                                @foreach ($this->rfqForm as $tradeTerm)
                                    @if ($tradeTerm->type == 'trade_terms')
                                        <div class="col-xl-1 col-lg-2 col-md-3 col-sm-4 col-6">
                                            <div class="form-check-inline" data-bs-toggle="tooltip" data-bs-title="{{ read_lang($tradeTerm, 'title2') }}">
                                                <input class="form-check-input" type="checkbox" value="{{ $tradeTerm->title1 }}" id="trade{{ $tradeTerm->title1 }}" wire:model.defer="trade_terms">
                                                <label class="form-check-label" for="trade{{ $tradeTerm->title1 }}">{{ $tradeTerm->title1 }}</label>
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                        @error('trade_terms')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6 col-xl-4">
                        <label for="budgetLimit" class="form-label fw-bold">{{ read_lang_word('budget-limit') }}: <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <div class="select-container">
                                <select id="" wire:model.defer="budget_limit" required>
                                    @foreach ($this->rfqForm as $budget_limit)
                                        @if ($budget_limit->type == 'budget_limit')
                                            <option value="{{ read_lang($budget_limit, 'title1') }}">
                                                {{ read_lang($budget_limit, 'title1') }}
                                            </option>
                                        @endif
                                    @endforeach
                                </select>
                            </div>
                            <span class="input-group-text">USD</span>
                        </div>
                        @error('budget_limit')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6 col-xl-4">
                        <label for="expectedUnitPrice" class="form-label fw-bold">{{ read_lang_word('expected-unit-price') }}
                            :</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="expectedUnitPrice" wire:model.defer="expected_unit_price">
                            <div class="input-group-select select-container">
                                <select id="expected_unit_price_currency" wire:model.defer="expected_unit_price_currency" required>
                                    @foreach ($this->rfqForm as $expected_unit_price)
                                        @if ($expected_unit_price->type == 'expected_unit_price')
                                            <option value="{{ read_lang($expected_unit_price, 'title1') }}">
                                                {{ read_lang($expected_unit_price, 'title1') }}
                                            </option>
                                        @endif
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        @error('expected_unit_price')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                        @error('expected_unit_price_currency')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-12 col-xl-4">
                        <label for="buyingFrequency" class="form-label fw-bold">{{ read_lang_word('buying-frequency') }}
                            :</label>
                        <div class="select-container">
                            <select id="buyingFrequency" wire:model.defer="buying_frequency" class="form-select">
                                @foreach ($this->rfqForm as $bying_frequency)
                                    @if ($bying_frequency->type == 'bying_frequency')
                                        <option value="{{ read_lang($bying_frequency, 'title1') }}">
                                            {{ read_lang($bying_frequency, 'title1') }}
                                        </option>
                                    @endif
                                @endforeach
                            </select>
                            @error('buying_frequency')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>


                    <div class="col-12">
                        <label class="form-label fw-bold">Shipping Method: <span class="text-danger">*</span></label>
                        <div class="row g-2">
                            @foreach ($this->rfqForm as $shipping_method)
                                @if ($shipping_method->type == 'shipping_method')
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="checkbox" id="ship{{ str_replace(' ', '_', $shipping_method->title1) }}" value="{{ $shipping_method->title1 }}" wire:model.defer="shipping_method">
                                            <label class="form-check-label" for="ship{{ str_replace(' ', '_', $shipping_method->title1) }}">{{ read_lang($shipping_method, 'title1') }}</label>
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                        @error('shipping_method')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label for="destination" class="form-label fw-bold">{{ read_lang_word('destination') }}: <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="destination" wire:model.defer="destination" required>
                        @error('destination')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label for="paymentTerms" class="form-label fw-bold">{{ read_lang_word('payment-terms') }}:
                            <span class="text-danger">*</span></label>
                        <div class="select-container">
                            <select id="paymentTerms" wire:model.defer="payment_terms" class="form-select" required>
                                @foreach ($this->rfqForm as $payment_terms)
                                    @if ($payment_terms->type == 'payment_terms')
                                        <option value="{{ $payment_terms->title1 }}">
                                            {{ read_lang($payment_terms, 'title1') }}
                                        </option>
                                    @endif
                                @endforeach
                            </select>
                        </div>
                        @error('payment_terms')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label for="deliveryTime" class="form-label fw-bold">{{ read_lang_word('delivery-time') }}
                            :</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="deliveryTime" wire:model.defer="delivery_time" placeholder="eg: 10">
                            <span class="input-group-text">{{ read_lang_word('days') }}</span>
                        </div>
                        <div class="form-text" style="font-size: 0.8em;">
                            {{ read_lang_word('delivery-time-starts-after-supplier-receives-the-initial-payments') }}
                        </div>
                        @error('delivery_time')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label for="rfqExpiry" class="form-label fw-bold">{{ read_lang_word('rfq-expiry') }}:</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="rfqExpiry" wire:model.defer="rfq_expiry" placeholder="eg: 5">
                            <div class="input-group-select select-container">
                                <select id="" wire:model.defer="rfq_expiry_type" required>
                                    @foreach ($this->rfqForm as $rfq_expiry)
                                        @if ($rfq_expiry->type == 'rfq_expiry')
                                            <option value="{{ $rfq_expiry->title1 }}">
                                                {{ read_lang($rfq_expiry, 'title1') }}
                                            </option>
                                        @endif
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        @error('rfq_expiry')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                        @error('rfq_expiry_type')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-12">
                        @if (auth()->user())
                            <button type="submit" class="submit-btn">
                                SUBMIT YOUR REQUEST
                            </button>
                        @else
                            <a href="{{ route('front.loginnew') }}" class="btn btn-warning">
                                {{ read_lang_word('product-alert') }}
                            </a>
                        @endif

                    </div>
                </form>
            </div>
        </div>
    </div>


</div>
