<div>
    <form wire:submit.prevent="submit" onkeydown="if(event.key === 'Enter') event.preventDefault();">
        <div class="mb-3">
            <label for="service" class="form-label">{{ read_lang_word('service') }}</label>
            <div class="select-container">
                <select class="form-control" id="service" wire:model.change="selectedService" required>
                    <option selected value="">{{ read_lang_word('select-service').' *' }}</option>
                    @foreach($this->services as $service)
                        <option value="{{ $service->id }}">{{ read_lang($service,'title') }}</option>
                    @endforeach
                </select>
            </div>
            @error('selectedService')
            <div class="text-danger small">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="sub-service" class="form-label">{{ read_lang_word('sub-service') }}</label>
            <div class="select-container">
                <select class="form-control" id="sub-service"
                        wire:model="selectedSubService" {{ !$this->selectedService ? 'disabled' : '' }}>
                    <option selected value="selected">{{ read_lang_word('select-sub-service') }}</option>
                    @foreach($this->subServices as $sub)
                        <option value="{{ $sub->id }}">{{ read_lang($sub,'title') }}</option>
                    @endforeach
                </select>
            </div>
            @error('selectedSubService')
            <div class="text-danger small">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3 form-check">
            <label for="verified-providers"
                   class="form-check-label">{{ read_lang_word('verified-service-providers') }}</label>
            <input type="checkbox" class="form-check-input" id="verified-providers"
                   wire:model.defer="verifiedProviders">
            @error('verifiedProviders')
            <div class="text-danger small">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3" wire:ignore
             x-data="{
         keywordOptions: @js($initialKeywords),
         init() {
             new TomSelect(this.$refs.keywordsInput, {
                 plugins: ['remove_button'],
                 create: true,
                 persist: false,
                 maxItems: 10,
                 delimiter: ',',
                 valueField: 'value',
                 labelField: 'text',
                 searchField: 'text',
                 options: this.keywordOptions.map(item => ({value: item, text: item})),
                 onChange: (value) => {
                     @this.set('serviceName', value.join(','));
                 },
                 onInitialize: function() {
                     this.setValue(@this.serviceName.split(','));
                 }
             });
         }
     }">
            <label class="form-label">{{ read_lang_word('service-name-or-keywords') }}</label>
            <select x-ref="keywordsInput" multiple></select>
            @error('serviceName')
            <div class="text-danger small">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-4">
            <textarea class="form-control" rows="5" placeholder="{{ read_lang_word('service-description') }}"
                      wire:model.defer="serviceDescription"></textarea>
            @error('serviceDescription')
            <div class="text-danger small">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-buttons">
            <button type="submit" class="default-button">{{ read_lang_word('submit-form') }}</button>
            <button type="button" class="default-button" wire:click="resetForm">{{ read_lang_word('reset') }}</button>
        </div>
    </form>

    @push('styles')
        <script defer src="{{url('assets/front/new/js/alpine.min.js')}}"></script>

        <!-- TomSelect -->
        <link href="{{url('assets/front/new/css/tom_select.css')}}" rel="stylesheet">
        <script src="{{url('assets/front/new/js/tom_select.min.js')}}"></script>
        <style>
            .ts-control, .ts-wrapper.single.input-active .ts-control{
                background-color: var(--grayBack);
                transition: background-color 0.5s ease, border 0.5s ease;
            }
            .ts-control:hover,
            .ts-wrapper.single.input-active:hover .ts-control {
                background-color: white;
                border: black solid 1px;
            }
            .ts-wrapper.multi .ts-control > div {
                background: #ffffff;
            }
        </style>
    @endpush

    @push('scripts')
        <script>
            const Toast = Swal.mixin({
                toast: true,
                position: "top-end",
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.onmouseenter = Swal.stopTimer;
                    toast.onmouseleave = Swal.resumeTimer;
                }
            });
            document.addEventListener('livewire:init', () => {
                Livewire.on('alert', (value) => {
                    Toast.fire({
                        icon: value['icon'],
                        title: value['title']
                    });
                });

                Livewire.on('resetPage', () => {
                    location.reload();
                });
            });

        </script>
    @endpush
</div>