<?php

use App\Http\Controllers\Admin\Blog\BlogCategoryController;
use App\Http\Controllers\Admin\Blog\TagController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\Access\PermissionCatController;
use App\Http\Controllers\Admin\Access\PermissionController;
use App\Http\Controllers\Admin\Access\RoleController;

use App\Http\Controllers\Admin\Form\AllFormController;
use App\Http\Controllers\Admin\Form\FeedbackController;
use App\Http\Controllers\Admin\Form\RequiredServiceController;

use App\Http\Controllers\Admin\Setting\MediaController;
use App\Http\Controllers\Admin\Setting\LangSetController;
use App\Http\Controllers\Admin\Setting\ProfileController;
use App\Http\Controllers\Admin\Setting\SliderController;
use App\Http\Controllers\Admin\Setting\MetaController;
use App\Http\Controllers\Admin\Setting\SelectController;
use App\Http\Controllers\Admin\Setting\AboutController;
use App\Http\Controllers\Admin\Setting\SettingController;
use App\Http\Controllers\Admin\Setting\SettingSaleController;
use App\Http\Controllers\Admin\Setting\ContactController;
use App\Http\Controllers\Admin\Setting\UploadController;
use App\Http\Controllers\Admin\Setting\SiteWordController;
use App\Http\Controllers\Admin\Setting\UploadSitemapController;
use App\Http\Controllers\Admin\Setting\UploadRobotController;
use App\Http\Controllers\Admin\Setting\RedirectController;
use App\Http\Controllers\Admin\Setting\NotificationBarController;

use App\Http\Controllers\Admin\User\UserController;

use App\Http\Controllers\Admin\Blog\BlogController;

use App\Http\Controllers\Admin\Other\ServiceController;
use App\Http\Controllers\Admin\Other\TransportController;
use App\Http\Controllers\Admin\Other\SourcingMagazineController;
use App\Http\Controllers\Admin\Other\FaqController;
use App\Http\Controllers\Admin\Other\LearningController;
use App\Http\Controllers\Admin\Other\RatingController;
use App\Http\Controllers\Admin\Other\CertificateController;
use App\Http\Controllers\Admin\Other\PartnerController;
use App\Http\Controllers\Admin\Other\BannerController;
use App\Http\Controllers\Admin\Other\ExhibitionController;
use App\Http\Controllers\Admin\Other\IndustryController;

use App\Http\Controllers\Admin\Product\CategorySupplierController;
use App\Http\Controllers\Admin\Product\CategoryController;
use App\Http\Controllers\Admin\Product\ProductController;
use App\Http\Controllers\Admin\Product\ProductServiceController;

use App\Http\Controllers\Admin\Gallery\GalleryController;

use App\Http\Controllers\Admin\Land\LandingController;
use App\Http\Controllers\Admin\Land\ExhibitionDateController;

use App\Http\Controllers\Admin\Rfq\RfqFormController;

use App\Http\Controllers\Admin\Company\CompanyFormController;
use App\Http\Controllers\Admin\Company\GeneralInformationController;
use App\Http\Controllers\Admin\Company\ContactInformationController;
use App\Http\Controllers\Admin\Company\BusinessInformationController;
use App\Http\Controllers\Admin\Company\TradingInformationController;
use App\Http\Controllers\Admin\Company\FactoryInformationController;
use App\Http\Controllers\Admin\Company\OfficeInformationController;

//Access
Route::resource('permission-cat', PermissionCatController::class);
Route::resource('permission', PermissionController::class);
Route::resource('role', RoleController::class);

//Setting
Route::get('profile', [ProfileController::class,'show'])->name('profile.show');
Route::get('profile/edit', [ProfileController::class,'edit'])->name('profile.edit');
Route::get('profile/edit/verify', [ProfileController::class,'edit_verify'])->name('profile.edit.verify');
Route::get('profile/edit/address', [ProfileController::class,'edit_address'])->name('profile.edit.address');
Route::get('profile/edited/address/{id}', [ProfileController::class,'edited_address'])->name('profile.edited.address');
Route::patch('profile/update', [ProfileController::class,'update'])->name('profile.update');
Route::patch('profile/update/verify', [ProfileController::class,'update_verify'])->name('profile.update.verify');
Route::patch('profile/update/address', [ProfileController::class,'update_address'])->name('profile.update.address');
Route::patch('profile/updated/address/{id}', [ProfileController::class,'updated_address'])->name('profile.updated.address');
Route::get('profile/delete/verify/{id}/certificate', [ProfileController::class,'delete_verify_certificate'])->name('profile.delete.verify.certificate');
Route::get('profile/delete/address/{id}', [ProfileController::class,'delete_address'])->name('profile.delete.address');
Route::get('profile/{id}/package/sale', [ProfileController::class,'package_sale'])->name('profile.package.sale');

Route::resource('lang-set', LangSetController::class);
Route::get('lang-set-status/{id}/{type}/{status}', [LangSetController::class,'status'])->name('lang-set.status');

Route::resource('meta', MetaController::class);
Route::get('meta-status/{id}/{type}/{status}', [MetaController::class,'status'])->name('meta.status');

Route::resource('select', SelectController::class);
Route::get('select-status/{id}/{type}/{status}', [SelectController::class,'status'])->name('select.status');

Route::resource('about', AboutController::class);
Route::get('about/option/list', [AboutController::class,'option_index'])->name('about.option.index');
Route::get('about/option/create', [AboutController::class,'option_create'])->name('about.option.create');
Route::post('about/option/store', [AboutController::class,'option_store'])->name('about.option.store');
Route::get('about/option/edit/{id}', [AboutController::class,'option_edit'])->name('about.option.edit');
Route::patch('about/option/update/{id}', [AboutController::class,'option_update'])->name('about.option.update');
Route::delete('about/option/destroy/{id}', [AboutController::class,'option_destroy'])->name('about.option.destroy');

Route::resource('setting-sale', SettingSaleController::class);

Route::resource('setting', SettingController::class);
Route::get('pic-delete/{id}', [SettingController::class,'delete_pic'])->name('pic.delete');
Route::get('delete-photo/', [SettingController::class,'delete_photo'])->name('setting.delete.photo');

Route::resource('contact', ContactController::class);

Route::resource('upload', UploadController::class);
Route::resource('upload-robots', UploadRobotController::class);
Route::resource('upload-sitemaps', UploadSitemapController::class);

Route::resource('site-word', SiteWordController::class);

Route::resource('slider', SliderController::class);
Route::get('slider-status/{id}/{type}/{status}', [SliderController::class,'status'])->name('slider.status');
Route::resource('notification-bar', NotificationBarController::class);

//User
Route::resource('user', UserController::class);
Route::get('user-status/{id}/{type}/{status}', [UserController::class,'status'])->name('user.status');
Route::get('user/permission/{id}/edit', [UserController::class,'permission_edit'])->name('user.edit.permission');
Route::post('user/permission/{id}/update', [UserController::class,'permission_update'])->name('user.update.permission');
Route::get('user/fast/{id}/login', [UserController::class,'fast_login'])->name('user.fast.login');
Route::get('user/fast/login', [UserController::class,'back_login'])->name('user.back.login');

//Form
Route::get('form/contact/list', [AllFormController::class,'contact'])->name('form.contact.index');
Route::get('form/sell/your/product/list', [AllFormController::class,'sell_your_product'])->name('form.sell.your.product.index');
Route::get('form/sell/your/product/list/{id}/status', [AllFormController::class,'sell_your_product_status'])->name('form.sell.your.product.status');

Route::get('form/feedback/story/list', [FeedbackController::class,'index1'])->name('feedback.story.index');
Route::get('form/feedback/video/list', [FeedbackController::class,'index2'])->name('feedback.video.index');

Route::get('form/feedback/show/{id}', [FeedbackController::class,'show'])->name('feedback.show');
Route::post('form/feedback/update/{id}', [FeedbackController::class,'update'])->name('feedback.update');

Route::resource('required-service', RequiredServiceController::class);

//Blog
Route::resource('blog', BlogController::class);

Route::post('blog-sort/{id}', [BlogController::class,'sort'])->name('blog.sort');

//Blog Category
Route::resource('blog-category', BlogCategoryController::class);
Route::post('blog-category-sort/{id}', [BlogCategoryController::class,'sort'])->name('blog-category.sort');

//Product
Route::resource('product-category', CategoryController::class);
Route::post('product-category-sort/{id}', [CategoryController::class,'sort'])->name('product-category.sort');
Route::post('product-category-import', [CategoryController::class,'import_excel'])->name('product-category.import');

//ProductSupplier
Route::resource('product-category-supplier', CategorySupplierController::class);
Route::post('product-category-supplier-sort/{id}', [CategorySupplierController::class,'sort'])->name('product-category-supplier.sort');

Route::resource('product', ProductController::class);
Route::get('product/{id}/price', [ProductController::class,'product_price'])->name('product.price');
Route::post('product/{id}/price/new', [ProductController::class,'product_price_new'])->name('product.price.store');
Route::post('product/{id}/price/update', [ProductController::class,'product_price_update'])->name('product.price.update');
Route::get('product/{id}/price/remove', [ProductController::class,'product_price_remove'])->name('product.price.remove');
Route::get('product/{id}/feature', [ProductController::class,'product_feature'])->name('product.feature');
Route::post('product/{id}/feature/new', [ProductController::class,'product_feature_new'])->name('product.feature.store');
Route::post('product/{id}/feature/update', [ProductController::class,'product_feature_update'])->name('product.feature.update');
Route::get('product/{id}/feature/remove', [ProductController::class,'product_feature_remove'])->name('product.feature.remove');
Route::resource('product-service', ProductServiceController::class);
Route::get('product-service/{id}/price', [ProductServiceController::class,'product_price'])->name('product-service.price');
Route::post('product-service/{id}/price/new', [ProductServiceController::class,'product_price_new'])->name('product-service.price.store');
Route::post('product-service/{id}/price/update', [ProductServiceController::class,'product_price_update'])->name('product-service.price.update');
Route::get('product-service/{id}/price/remove', [ProductServiceController::class,'product_price_remove'])->name('product-service.price.remove');
Route::get('product-service/{id}/feature', [ProductServiceController::class,'product_feature'])->name('product-service.feature');
Route::post('product-service/{id}/feature/new', [ProductServiceController::class,'product_feature_new'])->name('product-service.feature.store');
Route::post('product-service/{id}/feature/update', [ProductServiceController::class,'product_feature_update'])->name('product-service.feature.update');
Route::get('product-service/{id}/feature/remove', [ProductServiceController::class,'product_feature_remove'])->name('product-service.feature.remove');
//other
Route::resource('service', ServiceController::class);
Route::post('service-sort/{id}', [ServiceController::class,'sort'])->name('service.sort');
Route::resource('learning', LearningController::class);
Route::resource('rating', RatingController::class);
Route::resource('other-exhibition', ExhibitionController::class);
Route::resource('industry', IndustryController::class);


Route::resource('transport', TransportController::class);
Route::post('transport-sort/{id}', [TransportController::class,'sort'])->name('transport.sort');
Route::post('transport-top-page', [TransportController::class,'top_page'])->name('transport.top.page');

Route::resource('sourcing-magazine', SourcingMagazineController::class);
Route::post('sourcing-magazine-sort/{id}', [SourcingMagazineController::class,'sort'])->name('sourcing-magazine.sort');
Route::post('sourcing-magazine-top-page', [SourcingMagazineController::class,'top_page'])->name('sourcing-magazine.top.page');

//Certificate
Route::resource('certificate', CertificateController::class);
//Partner
Route::resource('partner', PartnerController::class);
//Banner
Route::resource('banner', BannerController::class);

//faq
Route::resource('faq', FaqController::class);
Route::post('faq-sort/{id}', [FaqController::class,'sort'])->name('faq.sort');

//Gallery
Route::resource('gallery', GalleryController::class);
Route::get('gallery-status/{id}/{type}/{status}', [GalleryController::class,'status'])->name('gallery.status');
Route::post('gallery-sort/{id}', [GalleryController::class,'sort'])->name('gallery.sort');
Route::get('gallery-delete/{id}', [GalleryController::class,'delete'])->name('gallery.delete');

Route::get('media', [MediaController::class, 'index'])->name('media.index');
Route::post('media/{id}', [MediaController::class, 'edit_alt'])->name('media.edit_alt');

//410
Route::resource('redirect', RedirectController::class);
Route::get('redirect-status/{id}/{status}', [RedirectController::class,'status'])->name('redirect.status');

//Tag
Route::resource('tags', TagController::class);
Route::post('tag-sort/{id}', [TagController::class,'sort'])->name('tags.sort');

//landing
Route::resource('land', LandingController::class);
//exhibition
Route::resource('exhibition', ExhibitionDateController::class);

//change lang
Route::get('chat/show', function () {
    return view('admin.chat');
})->name('chat.show');
//change lang
Route::get('change-lang/{lang}/{dir}', function ($lang,$dir) {
    session(['admin-lang'=>$lang]);
    session()->put('admin-dir', $dir);
    return redirect()->back();
})->name('change.lang');

//rfq
Route::resource('rfq-form', RfqFormController::class);
Route::post('rfq-form/{id}', [RfqFormController::class,'sort'])->name('rfq-form.sort');
Route::get('rfq-list/', [RfqFormController::class,'index2'])->name('rfq-form.index2');

//company
Route::resource('general-information', GeneralInformationController::class);
Route::resource('contact-information', ContactInformationController::class);
Route::resource('business-information', BusinessInformationController::class);
Route::resource('trading-information', TradingInformationController::class);
Route::resource('factory-information', FactoryInformationController::class);
Route::resource('office-information', OfficeInformationController::class);

Route::resource('company-form', CompanyFormController::class);
Route::post('company-form/{id}', [CompanyFormController::class,'sort'])->name('company-form.sort');
