<div>
    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('dashboard.page-title', ['pageTitle' => $page_title,'page_title' => $page_title]);

$__html = app('livewire')->mount($__name, $__params, 'lw-3371786591-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    <div class="container-fluid" x-data="{tab:1,formTab:1,createGroup: false}">
        <div class="btn-group btn-group-sm mb-2 d-table" role="group">
            <button :class="{'btn-primary text-white': tab == 1}" @click="tab = 1"
                    class="btn btn-outline-primary"><?php echo e(translateText('By Category', lang_admin())); ?></button>
            <button :class="{'btn-primary text-white': tab == 2}" @click="tab = 2"
                    class="btn btn-outline-primary"><?php echo e(translateText('By Ai', lang_admin())); ?></button>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card" x-show="tab == 1">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5><?php echo e($title.' | '.translateText('By Category', lang_admin())); ?></h5>
                        <div class="d-flex align-items-center">
                            <button :class="{'btn-primary text-white': formTab == 1}" @click="formTab = 1" class="btn btn-outline-danger circle-btn">1</button>
                            <div class="pagination-divider"></div>
                            <button :class="{'btn-primary text-white': formTab == 2}" @click="formTab = 2" class="btn btn-outline-danger circle-btn">2</button>
                            <div class="pagination-divider"></div>
                            <button :class="{'btn-primary text-white': formTab == 3}" @click="formTab = 3" class="btn btn-outline-danger circle-btn">3</button>
                            <div class="pagination-divider"></div>
                            <button :class="{'btn-primary text-white': formTab == 4}" @click="formTab = 4" class="btn btn-outline-danger circle-btn">4</button>
                        </div>
                    </div>
                    <div class="card-body">
                        <form enctype="multipart/form-data" x-data="{ isUploading: false }" wire:submit.prevent="save"
                              x-on:submit="$dispatch('update-ckeditor-values')">
                            <div class=""
                                 x-on:livewire-upload-start="isUploading = true"
                                 x-on:livewire-upload-finish="isUploading = false"
                                 x-on:livewire-upload-error="isUploading = false">
                                <div class="row" x-show="formTab == 1">
                                    <h5 class="mb-4 text-secondary"><?php echo e(translateText('Main Product Information', lang_admin())); ?></h5>
                                    <div class="col-md-12 mb-3" x-data="{tabB: 'en'}">
                                        <label><?php echo e(translateText('Product Details', lang_admin())); ?></label>

                                        <nav class="nav nav-tabs">
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = tab_langs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <button class="nav-link"
                                                        :class="{'active' : tabB == '<?php echo e($lang->lang); ?>'}"
                                                        type="button"
                                                        @click="tabB = '<?php echo e($lang->lang); ?>'">
                                                    <?php echo e(strtoupper($lang->lang)); ?>

                                                </button>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        </nav>

                                        <div class="tab-content p-3 border border-top-0">
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = tab_langs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
                                                    $dir = $lang->align;
                                                    $uniqueKey = "description{$suffix}";
                                                ?>

                                                <div class="tab-pane"
                                                     :class="{'show active d-block' : tabB == '<?php echo e($lang->lang); ?>'}"
                                                     x-show="tabB == '<?php echo e($lang->lang); ?>'"
                                                     style="direction: <?php echo e($dir); ?>">

                                                    <div wire:ignore class="col-md-12 mb-3" style="direction:ltr">
                                                        <label><?php echo e(translateText('Status', lang_admin())); ?></label>
                                                        <div class="form-check form-switch form-check-reverse"
                                                             style="padding-left: 20px">
                                                            <input wire:model="data.status<?php echo e($suffix); ?>"
                                                                   class="form-check-input badge-light-info ms-2"
                                                                   id="flexSwitchCheckReverse<?php echo e($suffix); ?>" type="checkbox">
                                                            <label class="form-check-label"
                                                                   for="flexSwitchCheckReverse<?php echo e($suffix); ?>">
                                                                <?php echo e(translateText('Will it be published?', lang_admin())); ?>

                                                            </label>
                                                        </div>
                                                    </div>

                                                    <div class="mb-3">
                                                        <label>
                                                            <?php echo e(translateText('Product Name', lang_admin())); ?>

                                                            <?php echo $lang->status == 'default' ? "<span class='text-danger'>*</span>" : ''; ?>

                                                        </label>
                                                        <input type="text"
                                                               wire:model.defer="data.title<?php echo e($suffix); ?>"
                                                               class="form-control">
                                                    </div>

                                                    <div class="mb-3">
                                                        <label>
                                                            <?php echo e(translateText('Meta Title', lang_admin())); ?>

                                                        </label>
                                                        <input type="text"
                                                               wire:model.defer="data.meta_title<?php echo e($suffix); ?>"
                                                               class="form-control">
                                                    </div>

                                                    <div class="mb-3">
                                                        <label>
                                                            <?php echo e(translateText('Meta Description', lang_admin())); ?>

                                                        </label>
                                                        <input type="text"
                                                               wire:model.defer="data.meta_description<?php echo e($suffix); ?>"
                                                               class="form-control">
                                                    </div>

                                                    <div class="mb-3">
                                                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.tom-select', ['options' => $trendingKeywords,'value' => $data['keywords'],'field' => 'keywords'.e($suffix).'','isMultiple' => true,'immediateUpdate' => false,'keyword' => true,'required' => $lang->status == 'default' ? true : false,'label' => translateText('Product Keywords', lang_admin()),'placeholder' => ''.e(translateText('Enter or select product keywords.', lang_admin())).'','uniqueKey' => 'keywords'.e($suffix).'']);

$__html = app('livewire')->mount($__name, $__params, 'keywords'.e($suffix).'', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                                    </div>

                                                    <div class="mb-3">
                                                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.editor', ['value' => $data['description' . $suffix] ?? '','field' => 'description'.e($suffix).'','required' => $lang->status == 'default','label' => translateText('Product Description', lang_admin()),'uniqueKey' => $uniqueKey,'language' => $lang->lang,'contentsLangDirection' => $dir,'height' => '300px','toolbar' => $tools]);

$__html = app('livewire')->mount($__name, $__params, 'editor-'.e($uniqueKey).'', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>

                                    <div class="col-md-12 mb-3" wire:ignore>
                                        <label>
                                            <?php echo e(translateText('Slug', lang_admin())); ?>

                                            <span class="text-danger">*</span>
                                        </label>
                                        <input type="text"
                                               wire:model="data.slug"
                                               class="form-control"
                                               placeholder="e.g. my-product-title"
                                               dir="ltr"
                                               x-maska
                                               data-maska="A"
                                               data-maska-tokens="A:[a-z0-9\s-]:repeated| -: |-"
                                               x-init="$el.addEventListener('input', () => { $el.value = $el.value.toLowerCase().replace(/\s+/g, '-'); })">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label><?php echo e(translateText('Selected Category', lang_admin())); ?> <span
                                                    class="text-danger">*</span></label>
                                        <div @click="$wire.dispatch('open-category-selector')"
                                             class="form-control pointer">
                                            <?php echo $categoryTitle ?? "<span class='text-secondary fw-light'>Click to open modal!</span>"; ?>

                                        </div>
                                        <span class="mt-1"><?php echo e(translateText("Can't find what are you looking for?",lang_admin())); ?> <a
                                                    href="#"
                                                    class="text-primary"><?php echo e(translateText('Suggest a category!',lang_admin())); ?></a></span>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label><?php echo e(translateText('Product Group', lang_admin())); ?></label>
                                        <div class="d-flex mb-2 input-group">
                                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.tom-select', ['disabled' => $data['category_id'] == null ? true : false,'options' => $groups,'value' => $data['group_id'],'field' => 'group_id','immediateUpdate' => false,'keyword' => true,'style' => ['at'=>'width', 'val'=>'85%' ],'placeholder' => ''.e(translateText('Type a new group name or select one...', lang_admin())).'','uniqueKey' => 'group_id']);

$__html = app('livewire')->mount($__name, $__params, 'group_id', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                            <button wire:click="saveGroup" <?php echo e($data['category_id'] == null ? 'disabled' : ''); ?> style="height: 37.6px" class="btn btn-primary" type="button"><?php echo e(translateText('Add', lang_admin())); ?></button>
                                        </div>
                                        <span class="mt-1"><?php echo e(translateText("You can select one of the groups you have already added or add a new one.",lang_admin())); ?></span>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label><?php echo e(translateText('Brand Name', lang_admin())); ?> </label>
                                        <input class="form-control" wire:model="data.brand">
                                    </div>
                                    <div class="col-md-6 mb-3" x-data="{
                                            part1: '',
                                            part2: '',
                                            part3: '',
                                            part4: '',
                                            updateFullCode() {
                                                const fullCode = [this.part1, this.part2, this.part3, this.part4]
                                                    .map(part => part.padStart(part === this.part1 ? 4 : 2, '0'))
                                                    .join('.');
                                                this.$refs.hiddenInput.value = fullCode;
                                                this.$wire.set('data.us_hts_code', fullCode);
                                            }
                                        }">
                                        <label><?php echo e(translateText('US HTS Code', lang_admin())); ?></label>
                                        <div class="multi-segment-input d-flex gap-2">
                                            <input
                                                    x-model="part1"
                                                    @input="updateFullCode"
                                                    type="text"
                                                    placeholder="4444"
                                                    class="form-control text-center"
                                                    maxlength="4"
                                                    style="width: 25%;"
                                            >
                                            <span>.</span>
                                            <input
                                                    x-model="part2"
                                                    @input="updateFullCode"
                                                    type="text"
                                                    placeholder="00"
                                                    class="form-control text-center"
                                                    maxlength="2"
                                                    style="width: 15%;"
                                            >
                                            <span>.</span>
                                            <input
                                                    x-model="part3"
                                                    @input="updateFullCode"
                                                    type="text"
                                                    placeholder="22"
                                                    class="form-control text-center"
                                                    maxlength="2"
                                                    style="width: 15%;"
                                            >
                                            <span>.</span>
                                            <input
                                                    x-model="part4"
                                                    @input="updateFullCode"
                                                    type="text"
                                                    placeholder="33"
                                                    class="form-control text-center"
                                                    maxlength="2"
                                                    style="width: 15%;"
                                            >
                                            <input
                                                    type="hidden"
                                                    x-ref="hiddenInput"
                                                    wire:model="data.us_hts_code"
                                                    id="hts-code-input"
                                            >
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label><?php echo e(translateText('Model Number', lang_admin())); ?> </label>
                                        <input type="number" class="form-control"
                                               wire:model="data.model_number">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.tom-select', ['options' => $countries,'value' => $data['place_of_origin'],'field' => 'place_of_origin','immediateUpdate' => false,'label' => translateText('Place of origin', lang_admin()),'placeholder' => ''.e(translateText('Select Country', lang_admin())).'','uniqueKey' => 'place_of_origin']);

$__html = app('livewire')->mount($__name, $__params, 'tom-select-place_of_origin', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                    </div>
                                    <div class="col-md-12 mb-3" x-data="{ showOtherInput: false }">
                                        <label><?php echo e(translateText('Product Certifications', lang_admin())); ?></label>
                                        <div class="row">
                                            <div class="col-md-12 row">
                                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $certifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="form-check form-check-inline checkbox checkbox-dark mb-0 col-3">
                                                        <input class="form-check-input" type="checkbox"
                                                               wire:model="data.certifications" value="<?php echo e($item); ?>"
                                                               id="<?php echo e($item); ?>">
                                                        <label class="form-check-label"
                                                               for="<?php echo e($item); ?>"><?php echo e($item); ?></label>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>

                                            <div class="col-md-12 p-0">
                                                <div class="form-check form-check-inline checkbox checkbox-primary mb-0">
                                                    <input class="form-check-input" type="checkbox"
                                                           wire:model="data.certifications" value="other" id="other"
                                                           x-model="showOtherInput">
                                                    <label class="form-check-label"
                                                           for="other"><?php echo e(translateText('OTHER', lang_admin())); ?></label>
                                                </div>

                                                <div x-show="showOtherInput" class="">
                                                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.tom-select', ['options' => [],'value' => $data['other_certification'],'field' => 'other_certification','immediateUpdate' => false,'isMultiple' => true,'keyword' => true,'placeholder' => ''.e(translateText('Please write another certificate. You can write multiple ones.', lang_admin())).'','uniqueKey' => 'other_certification']);

$__html = app('livewire')->mount($__name, $__params, 'other_certification', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12 mb-3">
                                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.file-upload', ['type' => 'gallery','isMultiple' => true,'label' => translateText('Product Images', lang_admin()),'acceptedFormats' => 'jpeg,jpg,png,webp','maxSize' => '5120','dimensions' => '600x600','modelClass' => '\App\Models\Product','required' => true,'uniqueKey' => 'file-upload-gallery','uploadDisk' => 'livewire_file','pathPrefix' => 'assets/admin/uploads/product','maxFiles' => 5,'applyWatermark' => false]);

$__html = app('livewire')->mount($__name, $__params, 'file-upload-gallery', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                        <span class="mt-1"><?php echo e(translateText("For more information read",lang_admin())); ?> <a
                                                    href="#"
                                                    class="text-primary"><?php echo e(translateText('Guiedlines',lang_admin())); ?></a></span>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.file-upload', ['type' => 'brochure','isMultiple' => false,'label' => translateText('Product Brochure', lang_admin()),'acceptedFormats' => 'pdf,jpg','maxSize' => '10240','modelClass' => '\App\Models\Product','required' => false,'uniqueKey' => 'file-upload-brochure','uploadDisk' => 'livewire_file','pathPrefix' => 'assets/admin/uploads/product']);

$__html = app('livewire')->mount($__name, $__params, 'file-upload-brochure', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.file-upload', ['type' => 'video','isMultiple' => false,'label' => translateText('Product Video', lang_admin()),'acceptedFormats' => 'mp4','maxSize' => '10240','modelClass' => '\App\Models\Product','required' => false,'uniqueKey' => 'file-upload-video','uploadDisk' => 'livewire_file','pathPrefix' => 'assets/admin/uploads/Product']);

$__html = app('livewire')->mount($__name, $__params, 'file-upload-video', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                    </div>

                                    <div class="col-md-12 mb-3">
                                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.file-upload', ['type' => 'certificates','isMultiple' => true,'label' => translateText('Product Certificates', lang_admin()),'acceptedFormats' => 'pdf,jpg','maxSize' => '10240','modelClass' => '\App\Models\Product','uniqueKey' => 'file-upload-certificates','uploadDisk' => 'livewire_file','pathPrefix' => 'assets/admin/uploads/product','maxFiles' => 5,'applyWatermark' => false]);

$__html = app('livewire')->mount($__name, $__params, 'file-upload-certificates', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                    </div>
                                </div>

                                <div class="row" x-show="formTab == 2">
                                    <h5 class="mb-4 text-secondary"><?php echo e(translateText('Main product attributes', lang_admin())); ?></h5>
                                    <div class="col-md-12 mb-3" x-data="{tabA:en}">
                                        <label><?php echo e(translateText('Product Attributes', lang_admin())); ?></label>

                                        <nav class="nav nav-tabs">
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = tab_langs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <button class="nav-link"
                                                        :class="{'active' : tabA == <?php echo e($lang->lang); ?>}"
                                                        type="button"
                                                        @click="tabA = <?php echo e($lang->lang); ?>">
                                                    <?php echo e(strtoupper($lang->lang)); ?>

                                                </button>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        </nav>

                                        <div class="tab-content p-3 border border-top-0">
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = tab_langs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
                                                    $dir = $lang->align;
                                                ?>

                                                <div class="tab-pane fade"
                                                     :class="{'show active d-block' : tabA == <?php echo e($lang->lang); ?>}"
                                                     id="<?php echo e($lang->lang); ?>"
                                                     x-show="tabA == <?php echo e($lang->lang); ?>"
                                                     style="direction: <?php echo e($dir); ?>">

                                                    <div id="attributes-container<?php echo e($suffix); ?>">
                                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $data['attributes' . $suffix] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="d-flex mb-2 input-group">
                                                                <input type="text"
                                                                       wire:model="data.attributes<?php echo e($suffix); ?>.<?php echo e($index); ?>.title"
                                                                       class="form-control"
                                                                       placeholder="<?php echo e(translateText('Attribute name', lang_admin())); ?>">

                                                                <input type="text"
                                                                       wire:model="data.attributes<?php echo e($suffix); ?>.<?php echo e($index); ?>.value"
                                                                       class="form-control"
                                                                       placeholder="<?php echo e(translateText('Attribute value', lang_admin())); ?>">

                                                                <button type="button"
                                                                        wire:click="removeAttribute(<?php echo e($index); ?>, '<?php echo e($lang->lang); ?>')"
                                                                        class="btn btn-danger">
                                                                    <i class="fas fa-trash"></i>
                                                                </button>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                    </div>

                                                    <button type="button"
                                                            wire:loading.attr="disabled"
                                                            wire:click="addAttribute('<?php echo e($lang->status == 'default' ? '' : $lang->lang); ?>')"
                                                            class="btn btn-success mt-2">
                                                        <i class="fas fa-plus"></i> <?php echo e(translateText('Add Attribute', lang_admin())); ?>

                                                    </button>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>

                                <div class="row" x-show="formTab == 3">
                                    <h5 class="mb-4 text-secondary"><?php echo e(translateText('Product Price & Logestic Information', lang_admin())); ?></h5>
                                    <div class="col-md-12 mb-3">
                                        <label>
                                            <?php echo e(translateText('Minimum Order', lang_admin())); ?>

                                            <span class='text-danger'>*</span>
                                        </label>
                                        <div class="d-flex mb-2 input-group">
                                            <input wire:model="data.minimum_quantity"
                                                   type="text"
                                                   class="form-control"
                                                   placeholder="<?php echo e(translateText('Enter Quantity', lang_admin())); ?>">

                                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.tom-select', ['options' => $units,'value' => $data['minimum_unit'],'field' => 'minimum_unit','immediateUpdate' => false,'style' => ['at'=>'width', 'val'=>'50%' ],'placeholder' => ''.e(translateText('Select Unit', lang_admin())).'','uniqueKey' => 'minimum_unit']);

$__html = app('livewire')->mount($__name, $__params, 'minimum_unit', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                        </div>
                                    </div>
                                    <div class="col-md-12 mb-3" x-data="{priceTab:'fixed_price'}">
                                        <label>
                                            <?php echo e(translateText('FOB Price', lang_admin())); ?>

                                            <span class='text-danger'>*</span>
                                        </label>
                                        <div class="form-check radio radio-primary ps-0 main-icon-radio">
                                            <ul class="radio-wrapper justify-content-around">
                                                <li><input @click="priceTab = 'fixed_price'" class="form-check-input"
                                                           id="fixed_price" type="radio"
                                                           wire:model="data.fob_price" value="fixed_price"><label
                                                            class="form-check-label" for="fixed_price"><i
                                                                class="fa-solid fa-lock"></i><span><?php echo e(translateText('Fixed Price',lang_admin())); ?></span></label>
                                                </li>
                                                <li><input @click="priceTab = 'ladder_price'" class="form-check-input"
                                                           id="ladder_price" type="radio"
                                                           wire:model="data.fob_price" value="ladder_price"
                                                           checked=""><label
                                                            class="form-check-label" for="ladder_price"><i
                                                                class="fa-solid fa-chart-line"></i><span><?php echo e(translateText('Ladder Price',lang_admin())); ?></span></label>
                                                </li>
                                                <li><input @click="priceTab = 'price_range'" class="form-check-input"
                                                           id="price_range" type="radio"
                                                           wire:model="data.fob_price" value="price_range"><label
                                                            class="form-check-label" for="price_range"><i
                                                                class="fa-solid fa-arrows-alt-h"></i><span><?php echo e(translateText('Price Range',lang_admin())); ?></span></label>
                                                </li>
                                                <li><input @click="priceTab = 'negotiable'" class="form-check-input"
                                                           id="negotiable" type="radio"
                                                           wire:model="data.fob_price" value="negotiable"><label
                                                            class="form-check-label" for="negotiable"><i
                                                                class="fa-solid fa-handshake"></i><span><?php echo e(translateText('Negotiable',lang_admin())); ?></span></label>
                                                </li>
                                            </ul>
                                        </div>

                                        <div x-show="priceTab == 'fixed_price'" class="mt-3">
                                            <label>
                                                <?php echo e(translateText('Fixed Price', lang_admin())); ?>

                                                <span class='text-danger'>*</span>
                                            </label>
                                            <div class="d-flex mb-2 input-group">
                                                <input wire:model="data.amount" type="number" class="form-control"
                                                       placeholder="<?php echo e(translateText('Enter Price (US$)', lang_admin())); ?>">
                                                <select wire:model="data.minimum_unit" disabled class="form-control">
                                                    <option value=""><?php echo e(translateText('(Unit)',lang_admin())); ?></option>
                                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($key); ?>"><?php echo e($unit); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                </select>
                                                <div class="form-check form-check-inline checkbox checkbox-dark mb-0 col-3">
                                                    <input class="form-check-input" type="checkbox"
                                                           wire:model="data.negotiable" value="Negotiable"
                                                           id="Negotiable">
                                                    <label class="form-check-label"
                                                           for="Negotiable"><?php echo e(translateText('Negotiable',lang_admin())); ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div x-show="priceTab == 'ladder_price'" class="mt-3"
                                             x-data="ladderPriceManager()">
                                            <label>
                                                <?php echo e(translateText('Ladder Price', lang_admin())); ?>

                                                <span class='text-danger'>*</span>
                                            </label>

                                            <template x-for="(item, index) in ladderPrices" :key="index">
                                                <div class="d-flex mb-2 input-group">
                                                    <input x-model="item.fixed_quantity" type="number"
                                                           class="form-control"
                                                           placeholder="<?php echo e(translateText('MOQ', lang_admin())); ?>"
                                                           min="1" >
                                                    <input x-model="item.fixed_price" type="number" class="form-control"
                                                           placeholder="<?php echo e(translateText('Price (US$)', lang_admin())); ?>"
                                                           min="0" step="0.01" >
                                                    <button type="button" class="btn btn-danger"
                                                            @click="removeLadder(index)"
                                                            x-show="ladderPrices.length > 1">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </div>
                                            </template>

                                            <button type="button" class="btn btn-sm btn-success mb-3"
                                                    @click="addNewLadder">
                                                <i class="fas fa-plus"></i> <?php echo e(translateText('Add New Price Step', lang_admin())); ?>

                                            </button>

                                            <div class="form-check form-check-inline checkbox checkbox-dark mb-0 col-3">
                                                <input class="form-check-input" type="checkbox"
                                                       wire:model="data.negotiable"
                                                       value="Negotiable" id="Negotiable">
                                                <label class="form-check-label" for="Negotiable">
                                                    <?php echo e(translateText('Negotiable',lang_admin())); ?>

                                                </label>
                                            </div>
                                        </div>
                                        <div x-show="priceTab == 'price_range'" class="mt-3">
                                            <label>
                                                <?php echo e(translateText('Price Range', lang_admin())); ?>

                                                <span class='text-danger'>*</span>
                                            </label>
                                            <div class="d-flex mb-2 input-group">
                                                <input wire:model="data.amount" type="number" class="form-control"
                                                       placeholder="<?php echo e(translateText('Min Price (US$)',lang_admin())); ?>">
                                                <input wire:model="data.max_amount" type="number" class="form-control"
                                                       placeholder="<?php echo e(translateText('Max Price (US$)',lang_admin())); ?>">
                                                <div class="form-check form-check-inline checkbox checkbox-dark mb-0 col-3">
                                                    <input class="form-check-input" type="checkbox"
                                                           wire:model="data.negotiable" value="Negotiable"
                                                           id="Negotiable">
                                                    <label class="form-check-label"
                                                           for="Negotiable"><?php echo e(translateText('Negotiable',lang_admin())); ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div x-show="priceTab == 'negotiable'" class="mt-3">
                                            <label>
                                                <?php echo e(translateText('Negotiable', lang_admin())); ?>

                                            </label>
                                            <div class="d-flex mb-2 input-group">
                                                <?php echo e(translateText("Price can be negotiated depending on buyer's requirements. Please contact us for further discussion.",lang_admin())); ?>

                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label><?php echo e(translateText('Lead Time',lang_admin())); ?></label>
                                        <div class="d-flex mb-2 input-group align-items-center">
                                            <span class="mx-2">Between</span>
                                            <input wire:model="data.lead_time_start" class="form-control"
                                                   placeholder="e.g. 5">
                                            <span class="mx-2">to</span>
                                            <input wire:model="data.lead_time_end" class="form-control"
                                                   placeholder="e.g. 12">
                                            <span class="mx-2">days</span>
                                        </div>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.tom-select', ['options' => $countries,'value' => $data['nearest_port'],'field' => 'nearest_port','immediateUpdate' => false,'label' => translateText('Nearest Port', lang_admin()),'placeholder' => ''.e(translateText('Select Country', lang_admin())).'','uniqueKey' => 'nearest_port']);

$__html = app('livewire')->mount($__name, $__params, 'tom-select-nearest_port', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.tom-select', ['options' => $countries,'value' => $data['main_market'],'field' => 'main_market','immediateUpdate' => false,'isMultiple' => true,'label' => translateText('Main Market(s)', lang_admin()),'placeholder' => ''.e(translateText('Select Regions', lang_admin())).'','uniqueKey' => 'main_market']);

$__html = app('livewire')->mount($__name, $__params, 'tom-select-main_market', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                    </div>
                                    <div class="col-md-12 mb-3" x-data="{ showOtherInputMethod: false }">
                                        <label><?php echo e(translateText('Payment Methods', lang_admin())); ?></label>
                                        <div class="row">
                                            <div class="col-md-12 row">
                                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="form-check form-check-inline checkbox checkbox-dark mb-0 col-3">
                                                        <input class="form-check-input" type="checkbox"
                                                               wire:model="data.payment_methods" value="<?php echo e($item); ?>"
                                                               id="<?php echo e($item); ?>">
                                                        <label class="form-check-label"
                                                               for="<?php echo e($item); ?>"><?php echo e($item); ?></label>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>

                                            <div class="col-md-12 p-0">
                                                <div class="form-check form-check-inline checkbox checkbox-primary mb-0">
                                                    <input class="form-check-input" type="checkbox"
                                                           wire:model="data.payment_methods" value="other"
                                                           id="otherMethod"
                                                           x-model="showOtherInputMethod">
                                                    <label class="form-check-label"
                                                           for="otherMethod"><?php echo e(translateText('OTHER', lang_admin())); ?></label>
                                                </div>

                                                <div x-show="showOtherInputMethod">
                                                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.tom-select', ['options' => [],'value' => $data['other_payment_methods'],'field' => 'other_payment_methods','immediateUpdate' => false,'isMultiple' => true,'keyword' => true,'placeholder' => ''.e(translateText('Please write another payment method. You can write multiple ones.', lang_admin())).'','uniqueKey' => 'other_payment_methods']);

$__html = app('livewire')->mount($__name, $__params, 'other_payment_methods', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-8 mb-3" x-data="{ showInput: false }">
                                        <label><?php echo e(translateText('Sample Option',lang_admin())); ?></label>
                                        <div class="card-wrapper  rounded-3 h-100">
                                            <div class="form-check radio radio-primary">
                                                <input @click="showInput = true" class="form-check-input"
                                                       id="yes" type="radio" wire:model="data.sample_option"
                                                       value="yes">
                                                <label class="form-check-label" for="yes">
                                                    <?php echo e(translateText('Yes',lang_admin())); ?>

                                                </label>
                                            </div>
                                            <div class="form-check radio radio-primary">
                                                <input @click="showInput = false" class="form-check-input"
                                                       id="no" type="radio" wire:model="data.sample_option"
                                                       value="no">
                                                <label class="form-check-label" for="no">
                                                    <?php echo e(translateText('No',lang_admin())); ?>

                                                </label>
                                            </div>
                                            <div class="form-check radio radio-primary">
                                                <input @click="showInput = false" class="form-check-input"
                                                       id="contact" type="radio" wire:model="data.sample_option"
                                                       value="contact">
                                                <label class="form-check-label" for="contact">
                                                    <?php echo e(translateText('Contact us for sample request information',lang_admin())); ?>

                                                </label>
                                            </div>
                                            <div x-show="showInput" class=" mb-2 input-group align-items-center">
                                                <span class="mx-2"><?php echo e(translateText('Between',lang_admin())); ?></span>
                                                <input wire:model="data.sample_option_start" class="form-control"
                                                       placeholder="<?php echo e(translateText('Quantity',lang_admin())); ?>">
                                                <span class="mx-2"><?php echo e(translateText('to',lang_admin())); ?></span>
                                                <input wire:model="data.sample_option_end" class="form-control"
                                                       placeholder="<?php echo e(translateText('Quantity',lang_admin())); ?>">
                                                <input wire:model="data.sample_option_price" class="form-control"
                                                       placeholder="<?php echo e(translateText('Sample Price(US$)',lang_admin())); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row" x-show="formTab == 4">
                                    <h5 class="mb-4 text-secondary"><?php echo e(translateText('Packaging Information', lang_admin())); ?></h5>
                                    <div class="col-md-6 mb-3">
                                        <label><?php echo e(translateText('Product Dimensions (With Packaging)', lang_admin())); ?></label>
                                        <div class="d-flex input-group mb-2 align-items-center">
                                            <input wire:model="data.length" class="form-control" placeholder="Length">
                                            <input wire:model="data.width" class="form-control" placeholder="Width">
                                            <input wire:model="data.height" class="form-control" placeholder="Height">
                                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.tom-select', ['options' => $unit_of_measurement,'value' => $data['unit1'],'field' => 'unit1','immediateUpdate' => false,'placeholder' => ''.e(translateText('Select Unit', lang_admin())).'','uniqueKey' => 'unit1']);

$__html = app('livewire')->mount($__name, $__params, 'unit1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label><?php echo e(translateText('Product Weight (With Packaging)', lang_admin())); ?></label>
                                        <div class="d-flex input-group mb-2 align-items-center">
                                            <input wire:model="data.weight" class="form-control" placeholder="Weight">
                                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.tom-select', ['options' => $units,'value' => $data['unit2'],'field' => 'unit2','immediateUpdate' => false,'style' => ['at'=>'width', 'val'=>'50%' ],'placeholder' => ''.e(translateText('Select Unit', lang_admin())).'','uniqueKey' => 'unit2']);

$__html = app('livewire')->mount($__name, $__params, 'unit2', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                        </div>
                                    </div>
                                    <div class="col-md-12 mb-3">
                                        <div class="form-check form-check-inline checkbox checkbox-dark mb-0 col-3">
                                            <input class="form-check-input" type="checkbox" wire:model="data.showcase" id="showcase">
                                            <label class="form-check-label" for="showcase"><?php echo e(translateText('Mark as Showcase',lang_admin())); ?></label>
                                        </div>
                                    </div>
                                    <div class="col-md-12 mb-3">
                                        <div class="form-check form-check-inline checkbox checkbox-dark mb-0">
                                            <input class="form-check-input" type="checkbox" wire:model.live="data.conditions" id="conditions">
                                            <label class="form-check-label" for="conditions"><?php echo e(translateText('I hereby confirm that all submitted information is true and complies with Mainexpo’s Terms of Use. I take full responsibility for any violation, and Mainexpo reserves the right to remove any content that breaches its policies.',lang_admin())); ?></label>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="d-flex justify-content-between mt-4">
                                <button
                                        type="button"
                                        class="btn btn-secondary"
                                        @click="formTab--"
                                        x-show="formTab > 1"
                                >
                                    <i class="fas fa-arrow-left me-2"></i> Previous
                                </button>

                                <button
                                        type="button"
                                        class="btn btn-info ms-auto"
                                        @click="formTab++"
                                        x-show="formTab < 4"
                                >
                                    Next <i class="fas fa-arrow-right me-2"></i>
                                </button>
                                <!--[if BLOCK]><![endif]--><?php if($data['conditions']): ?>
                                    <button x-show="!isUploading && formTab == 4" wire:loading.attr="disabled"
                                            type="submit" class="btn btn-primary ms-auto">
                                        <?php echo e(translateText('Submit', lang_admin())); ?>

                                    </button>
                                <?php else: ?>
                                    <span x-show="!isUploading && formTab == 4" class="text-danger"><?php echo e(translateText('First agree to the terms and conditions.', lang_admin())); ?></span>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <span x-show="isUploading" class="text-info">
                                Uploading...
                                <i class="fas fa-spinner fa-spin me-2"></i>
                            </span>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="card" x-show="tab == 2">
                    <div class="card-header">
                        <h5><?php echo e($title.' | '.translateText('By Ai', lang_admin())); ?></h5>
                    </div>
                    <div class="card-body">
                        By Ai
                    </div>
                </div>
            </div>
        </div>
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('dashboard.items-and-services.product.category-selector', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3371786591-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    </div>
</div>
<?php $__env->startPush('styles'); ?>
    <style>
        .pagination-divider {
            height: 1px;
            width: 50px;
            background-color: #dc3545;
            margin: 0 12px;
            align-self: center;
        }
        .circle-btn {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 4px;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.store('ladderPriceState', {
                ladderPrices: <?php echo \Illuminate\Support\Js::from($data['ladder_prices'] ?? [])->toHtml() ?>,
                updateLadderPrices(value) {
                    this.ladderPrices = value;
                }
            });

            Alpine.data('ladderPriceManager', () => ({
                ladderPrices: Alpine.store('ladderPriceState').ladderPrices,

                addNewLadder() {
                    this.ladderPrices.push({
                        fixed_quantity: '',
                        fixed_price: ''
                    });
                    Alpine.store('ladderPriceState').updateLadderPrices(this.ladderPrices);
                },

                removeLadder(index) {
                    this.ladderPrices.splice(index, 1);
                    Alpine.store('ladderPriceState').updateLadderPrices(this.ladderPrices);
                },

                init() {
                    if (this.ladderPrices.length === 0) {
                        this.addNewLadder();
                    }

                    this.$watch('ladderPrices', (value) => {
                        Alpine.store('ladderPriceState').updateLadderPrices(value);
                    });

                    this.$el.closest('form').addEventListener('submit', () => {
                    window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('data.ladder_prices', Alpine.store('ladderPriceState').ladderPrices);
                    });
                }
            }));
        });
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /home/nexpo/public_html/new/source/resources/views/livewire/dashboard/items-and-services/product/create.blade.php ENDPATH**/ ?>