<div x-data="{ isOpen: false }">
    <button type="button" class="btn btn-success" @click="isOpen = true">
        <i class="fa fa-plus"></i><?php echo e(translateText('Add Faq', lang_admin())); ?>

    </button>

    <div class="modal fade" :class="{ 'show d-block': isOpen }" x-show="isOpen"
         @click.away="isOpen = false" role="dialog" aria-modal="true">
        <div class="modal-dialog mt-5 my-style-modal">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(translateText('Add New Faq', lang_admin())); ?></h5>
                    <button type="button" class="btn-close" @click="isOpen = false"
                            aria-label="Close"></button>
                </div>

                <form wire:submit.prevent="save">
                    <div class="modal-body">
                        <nav class="nav nav-tabs">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = tab_langs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button class="nav-link <?php echo e($lang->status == 'default' ? 'active' : ''); ?>"
                                        type="button"
                                        data-bs-toggle="tab"
                                        data-bs-target="#lang-<?php echo e($lang->lang); ?>">
                                    <?php echo e(strtoupper($lang->lang)); ?>

                                </button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </nav>

                        <div class="tab-content p-3 border border-top-0">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = tab_langs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
                                    $dir = $lang->align;
                                ?>
                                <div class="tab-pane fade <?php echo e($lang->status == 'default' ? 'show active' : ''); ?>"
                                     id="lang-<?php echo e($lang->lang); ?>" style="direction: <?php echo e($dir); ?>">
                                    <div wire:ignore class="col-md-12 mb-3" style="direction:ltr">
                                        <label><?php echo e(translateText('Status', lang_admin())); ?></label>
                                        <div class="form-check form-switch form-check-reverse"
                                             style="padding-left: 20px">
                                            <input wire:model="data.status<?php echo e($suffix); ?>"
                                                   class="form-check-input badge-light-info ms-2"
                                                   id="flexSwitchCheckReverse<?php echo e($suffix); ?>" type="checkbox">
                                            <label class="form-check-label"
                                                   for="flexSwitchCheckReverse<?php echo e($suffix); ?>">
                                                <?php echo e(translateText('Will it be published?', lang_admin())); ?>

                                            </label>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label>
                                            <?php echo e(translateText('Question', lang_admin())); ?>

                                            <?php echo $lang->status == 'default' ? "<span class='text-danger'>*</span>" : ''; ?>

                                        </label>
                                        <textarea <?php echo e($lang->status == 'default' ? "required" : ''); ?>  type="text"
                                               wire:model="data.question<?php echo e($suffix); ?>"
                                               class="form-control"></textarea>
                                    </div>
                                    <div class="mb-3">
                                        <label>
                                            <?php echo e(translateText('Answer', lang_admin())); ?>

                                            <?php echo $lang->status == 'default' ? "<span class='text-danger'>*</span>" : ''; ?>

                                        </label>
                                        <textarea <?php echo e($lang->status == 'default' ? "required" : ''); ?>  type="text"
                                                  wire:model="data.answer<?php echo e($suffix); ?>"
                                                  class="form-control"></textarea>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" @click="isOpen = false">
                            <?php echo e(translateText('Close', lang_admin())); ?>

                        </button>
                        <button type="submit" class="btn btn-primary">
                            <?php echo e(translateText('Save', lang_admin())); ?>

                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal-backdrop fade" :class="{ 'show': isOpen }" x-show="isOpen"></div>
</div><?php /**PATH /home/nexpo/public_html/new/source/resources/views/livewire/dashboard/company/company-faq/create.blade.php ENDPATH**/ ?>