<?php if(count($addresses) && $days > 0 && $user->verify_type == 'vip'): ?>
    <button class="btn btn-secondary w-100 border-radius-50px"  data-bs-toggle="modal"
            data-bs-target="#contactModal">
        <?php echo icon_svg('contact'); ?>

        <?php echo e(read_lang_word('product-contact')); ?>

    </button>
    <!-- Modal -->
    <div class="modal fade" id="contactModal" tabindex="-1" aria-labelledby="contactModalLabel"
         aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"
                        id="contactModalLabel"><?php echo e(read_lang_word('supplier-contact')); ?>(<?php echo e($user->name); ?>)</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                </div>
                <div class="modal-body editor-text">
                    <table class="table table-hover w-100">
                        <thead>
                        <tr>
                            <th><?php echo e(read_lang_word('supplier-address-name')); ?></th>
                            <th><?php echo e(read_lang_word('supplier-address-contact')); ?></th>
                            <th><?php echo e(read_lang_word('supplier-address-country')); ?></th>
                            <th><?php echo e(read_lang_word('supplier-address')); ?></th>
                            <th>Zip Code</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th><?php echo e($address->full_name); ?></th>
                                <td dir="ltr">
                                    <?php echo e(translateText('Phone:',lang_admin())); ?>

                                    <span dir="ltr"
                                          class="text-danger"><?php echo e($address->phone); ?></span>
                                    <br>
                                    <?php echo e(translateText('Fax:',lang_admin())); ?>

                                    <span dir="ltr" class="text-danger"><?php echo e($address->fax); ?></span>
                                    <br>
                                    <?php echo e(translateText('Mobile:',lang_admin())); ?>

                                    <span dir="ltr"
                                          class="text-danger"><?php echo e($address->mobile); ?></span>
                                    <br>
                                    <?php echo e(translateText('Email:',lang_admin())); ?>

                                    <span dir="ltr"
                                          class="text-danger"><?php echo e($address->email); ?></span>
                                </td>
                                <td><?php echo e($address->country ? $address->country->nicename : '__'); ?></td>
                                <td>
                                    <?php echo e($address->state); ?>/<?php echo e($address->city); ?>

                                    <br/>
                                    <?php echo e($address->address); ?>

                                </td>
                                <td><?php echo e($address->zip_code); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php else: ?>
    <a href="<?php echo e(route('front.contact.us')); ?>" target="_blank" class="btn btn-secondary w-100 border-radius-50px">
        <?php echo icon_svg('contact'); ?>

        <?php echo e(read_lang_word('product-contact')); ?>

    </a>
<?php endif; ?><?php /**PATH /home/nexpo/public_html/new/source/resources/views/front/product/includes/contact.blade.php ENDPATH**/ ?>