<div x-data="{ activeTab: 'basic' }" wire:ignore>
    <!--[if BLOCK]><![endif]--><?php if($label): ?>
        <label class="form-label"><?php echo e($label); ?><?php echo $required ? " <span class='text-danger'>*</span>" : ''; ?></label>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        <div class="btn-group btn-group-sm mb-2 d-table" role="group">
            <button type="button"
                    @click="activeTab = 'basic'"
                    :class="{'btn-primary text-white': activeTab == 'basic', 'btn-outline-primary': activeTab != 'basic'}"
                    class="btn">
                <?php echo e(translateText('Base', lang_admin())); ?>

            </button>
            <button type="button"
                    @click="activeTab = 'advanced'"
                    :class="{'btn-primary text-white': activeTab == 'advanced', 'btn-outline-primary': activeTab != 'advanced'}"
                    class="btn">
                <?php echo e(translateText('Advanced', lang_admin())); ?>

            </button>
        </div>
    <textarea
            x-data
            x-init="
            let editor;
            function initEditor() {
                if (window.ckeditorInstances && window.ckeditorInstances['<?php echo e($uniqueKey); ?>']) {
                    window.ckeditorInstances['<?php echo e($uniqueKey); ?>'].destroy(true);
                }

                let config = {
                    filebrowserImageBrowseUrl: <?php echo \Illuminate\Support\Js::from($filebrowserImageBrowseUrl)->toHtml() ?>,
                    filebrowserImageUploadUrl: <?php echo \Illuminate\Support\Js::from($filebrowserImageUploadUrl)->toHtml() ?>,
                    filebrowserBrowseUrl: <?php echo \Illuminate\Support\Js::from($filebrowserBrowseUrl)->toHtml() ?>,
                    filebrowserUploadUrl: <?php echo \Illuminate\Support\Js::from($filebrowserUploadUrl)->toHtml() ?>,
                    language: <?php echo \Illuminate\Support\Js::from($language)->toHtml() ?>,
                    contentsLangDirection: <?php echo \Illuminate\Support\Js::from($contentsLangDirection)->toHtml() ?>,
                    autoUpdateElement: false,
                    height: <?php echo \Illuminate\Support\Js::from($height)->toHtml() ?>,
                };

                if (activeTab === 'basic') {
                    config.toolbar = <?php echo \Illuminate\Support\Js::from($toolbar)->toHtml() ?>;
                }

                editor = CKEDITOR.replace($el, config);
                editor.setData(<?php echo \Illuminate\Support\Js::from($value)->toHtml() ?>);

                editor.on('change', function() {
                    window.ckeditorValues = window.ckeditorValues || {};
                    window.ckeditorValues['<?php echo e($uniqueKey); ?>'] = editor.getData();
                });

                window.ckeditorInstances = window.ckeditorInstances || {};
                window.ckeditorInstances['<?php echo e($uniqueKey); ?>'] = editor;

                window.addEventListener('update-ckeditor-values', () => {
                    if (window.ckeditorValues && window.ckeditorValues['<?php echo e($uniqueKey); ?>'] !== undefined) {
                        window.Livewire.find('<?php echo e($_instance->getId()); ?>').dispatch('ckeditor-updated', { field: '<?php echo e($field); ?>', value: window.ckeditorValues['<?php echo e($uniqueKey); ?>'] });
                        console.log('yes');
                    }
                });
            }

            $nextTick(() => {
                initEditor();
            });

            $watch('activeTab', () => {
                initEditor();
            });
        "
            wire:model.defer="<?php echo e($field); ?>"
            id="<?php echo e($uniqueKey); ?>"
        <?php echo e($required ? 'required' : ''); ?>

            <?php echo e($disabled ? 'disabled' : ''); ?>

    ><?php echo e($value); ?></textarea>
</div>

<?php $__env->startPush('styles'); ?>
    <style>
        .cke_chrome {
            border: 1px solid #d1d1d1 !important;
            border-radius: 4px !important;
        }
        .tabs button {
            margin-right: 5px;
        }
    </style>
<?php $__env->stopPush(); ?><?php /**PATH /home/nexpo/public_html/new/source/resources/views/livewire/components/editor.blade.php ENDPATH**/ ?>