<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(url('assets/front/css/fancybox.css')); ?>">
    <style>
        .fancybox__container {
            z-index: 99999;
        }

        table * {
            /*font-size: 13px;*/
        }

        table.dataTable tbody td, table.dataTable thead td {
            padding: 6px !important;
            vertical-align: middle;
        }

        table.dataTable tbody th, table.dataTable thead th {
            padding: 10px 6px !important;
            /*font-size: 13px!important;*/
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        <?php echo e($title); ?>

                        <?php if(!isset(request()->role)): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_create')): ?>
                                <a href="<?php echo e(route('admin.user.create')); ?>"
                                   class="btn btn-primary float-left"><?php echo e(translateText('افزودن',lang_admin())); ?></a>
                            <?php endif; ?>
                        <?php endif; ?>
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-wrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0"><?php echo e(translateText('نام',lang_admin())); ?></th>
                                <th class="border-bottom-0"><?php echo e(translateText('دسترسی',lang_admin())); ?></th>
                                <th class="border-bottom-0"><?php echo e(translateText('نام کاربری',lang_admin())); ?></th>
                                <th class="border-bottom-0"><?php echo e(translateText('شماره همراه',lang_admin())); ?></th>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_status')): ?>
                                    <th class="border-bottom-0"><?php echo e(translateText('وضعیت',lang_admin())); ?></th>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['user_edit','user_delete','user_access','user_fast_login'])): ?>
                                    <th class="border-bottom-0"><?php echo e(translateText('عملیات',lang_admin())); ?></th>
                                <?php endif; ?>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key+1); ?></td>
                                    <td>
                                        <?php echo e($item->name); ?>

                                    </td>
                                    <td dir="ltr">
                                        <?php echo e($item->roles->first()->title); ?>

                                    </td>
                                    <td dir="ltr">
                                        <?php echo e($item->username); ?>

                                    </td>
                                    <td dir="<?php echo e($item->mobile?'ltr':''); ?>">
                                        <?php echo e($item->mobile?$item->country_code.' '.$item->mobile:'__'); ?>

                                    </td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_status')): ?>
                                        <td>
                                            <?php echo e(translateText('وضعیت',lang_admin())); ?>:
                                            <?php if($item->status=='active'): ?>
                                                <span class="text-success ml-1"><?php echo e(translateText('فعال',lang_admin())); ?></span>
                                                <a href="<?php echo e(route('admin.user.status',[$item->id,'status','blocked'])); ?>">
                                                    <i class="fa fa-close text-danger"></i>
                                                </a>
                                            <?php else: ?>
                                                <span class="text-danger ml-1"><?php echo e(translateText('مسدود',lang_admin())); ?></span>
                                                <a href="<?php echo e(route('admin.user.status',[$item->id,'status','active'])); ?>">
                                                    <i class="fa fa-check text-success"></i>
                                                </a>
                                            <?php endif; ?>
                                            <?php if($item->hasRole(['buyer', 'supplier'])): ?>
                                                <br/>
                                                <?php echo e(translateText('Verify',lang_admin())); ?>:
                                                <?php if($item->status_verify=='active'): ?>
                                                    <span class="text-success ml-1"><?php echo e(translateText('فعال',lang_admin())); ?></span>
                                                    <a href="<?php echo e(route('admin.user.status',[$item->id,'status_verify','blocked'])); ?>">
                                                        <i class="fa fa-close text-danger"></i>
                                                    </a>
                                                <?php else: ?>
                                                    <span class="text-danger ml-1"><?php echo e(translateText('غیرفعال',lang_admin())); ?></span>
                                                    <a href="<?php echo e(route('admin.user.status',[$item->id,'status_verify','active'])); ?>">
                                                        <i class="fa fa-check text-success"></i>
                                                    </a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['user_edit','user_delete','user_access','user_fast_login'])): ?>
                                        <td>
                                            <div class="d-flex">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_status')): ?>
                                                    <?php if($item->hasRole(['buyer', 'supplier'])): ?>
                                                        <a href="javascript:void(0)" target="_blank"
                                                           class="action-btns1" data-toggle="modal"
                                                           data-target="#certificateModal<?php echo e($item->id); ?>">
                                                            <i class="fa fa-certificate text-primary"
                                                               data-toggle="tooltip" data-placement="top"
                                                               title="<?php echo e(translateText('مجوزها(اطلاعات بیشتر)',lang_admin())); ?>"></i>
                                                        </a>

                                                        <?php echo $__env->make('admin.user.include.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_fast_login')): ?>
                                                    <a href="<?php echo e(route('admin.user.fast.login',$item->id)); ?>"
                                                       class="action-btns1">
                                                        <i class="fa fa-sign-in text-dark"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="<?php echo e(translateText('ورود به پنل کاربر',lang_admin())); ?>"></i>
                                                    </a>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_access')): ?>
                                                    <a href="<?php echo e(route('admin.user.edit.permission',$item->id)); ?>"
                                                       class="action-btns1">
                                                        <i class="feather feather-lock  text-info"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="<?php echo e(translateText('مجوزها',lang_admin())); ?>"></i>
                                                    </a>
                                                <?php endif; ?>
                                                    <?php if(!isset(request()->role)): ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_edit')): ?>
                                                    <a href="<?php echo e(route('admin.user.edit',$item->id)); ?>"
                                                       class="action-btns1">
                                                        <i class="feather feather-edit-2  text-success"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="<?php echo e(translateText('ویرایش',lang_admin())); ?>"></i>
                                                    </a>
                                                <?php endif; ?>

                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_delete')): ?>
                                                    <?php echo Form::open(['method' => 'DELETE', 'route' => ['admin.user.destroy', $item->id] ]); ?>

                                                    <button class="action-btns1" data-toggle="tooltip"
                                                            data-placement="top"
                                                            title="<?php echo e(translateText('حذف',lang_admin())); ?>"
                                                            onclick="return confirm('<?php echo e(translateText('برای حذف مطمئن هستید؟',lang_admin())); ?>')">
                                                        <i class="feather feather-trash-2 text-danger"></i>
                                                    </button>
                                                    <?php echo Form::close(); ?>

                                                <?php endif; ?>
                                                        <?php endif; ?>
                                            </div>
                                        </td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('in_tag_script'); ?>
    <script src="<?php echo e(url('assets/front/js/fancybox.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app',['tbl'=>true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexpo/public_html/new/source/resources/views/admin/user/index.blade.php ENDPATH**/ ?>