<?php $__env->startSection('styles'); ?>
    <style>

    </style>
<?php $__env->stopSection(); ?>

<header>
    <!-- Header Top Side -->
    <?php if($notification_bar): ?>
    <div class="header-top-side">
        <div class="container-xxl">
            <div class="notif-content">
                <span class="header-message">
                   <?php echo e($notification_bar->title); ?>

                    <?php if($notification_bar->link != null): ?>
                        <a href="<?php echo e($notification_bar->link); ?>" style="color: #e54544"> click </a>
                    <?php endif; ?>
                    <button class="close-top-header" aria-label="close">
                        <i class="fa fa-x"></i>
                    </button>
                </span>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <!-- Header Top Side -->
    <div class="header-main-section">
        <div class="container-xxl">
            <div class="row g-3 g-lg-5 justify-content-between">
                <!-- Header Logo -->
                <div class="col col-lg-auto flex justify-content-start">
                    <a href="<?php echo e(route('front.index')); ?>">
                        <img src="<?php echo e($logo); ?>" alt="<?php echo e($titleSeo); ?>" class="header-logo" />
                    </a>
                </div>

                <!-- Search Box -->
                <div id="search_top" class="col flex d-none d-lg-flex">
                    <form action="<?php echo e(route('front.search')); ?>" id="searchForm" class="header-search">
                        <div class="select-container">
                            <select name="search_type" id="searchType">
                                <option value="products"><?php echo e(read_lang_word('search-select1')); ?></option>
                                <option value="services"><?php echo e(read_lang_word('search-select3')); ?></option>
                                <option value="suppliers"><?php echo e(read_lang_word('search-select2')); ?></option>
                                <option value="buyer"><?php echo e(read_lang_word('search-select4')); ?></option>
                            </select>
                        </div>
                        <input type="hidden" name="type" id="selectedCategory" value="products">

                        <div class="input-box">
                            <input type="text" id="searchInput" autocomplete="off" name="search" placeholder="<?php echo e(read_lang_word('search-text')); ?>" required />
                            <input type="hidden" id="searchSelectId" name="SelectId" value="">
                            <div id="suggestionsContainer" class="suggestions-container"></div>

                        </div>
                        <button type="submit" class="search-btn default-button">
                            <i class="fa-light fa-magnifying-glass"></i>
                        </button>
                    </form>
                </div>


                <!-- Header Buttons -->
                <div class="col-auto col-xl-auto">
                    <ul class="header-buttons-list">
                        <li class="d-md-flex d-none stiky-none">
                            <a href="<?php echo e(route('rfq')); ?>" class="header-button">
                                <div class="icon-box">
                                    <img class="normal-icon" src="<?php echo e(asset('assets/front/new/icon/rfq-normal.svg')); ?>" alt="">
                                    <img class="hover-icon" src="<?php echo e(asset('assets/front/new/icon/rfq-hover.svg')); ?>" alt="">
                                </div>
                                <span><?php echo e(read_lang_word('post-my-rfq')); ?></span>
                            </a>
                            <div class="menu-dropdown">
                                <span class="menu-dropdown-message">Tell Us What You Need, Get Multiple Quotes.</span>
                            </div>
                        </li>
                        <li class="stiky-none">
                            <?php if(Auth::check()): ?>
                                <a href="#" class="header-button">
                                    <div class="icon-box">
                                        <img class="normal-icon" src="<?php echo e(asset('assets/front/new/icon/signin-normal.svg')); ?>" alt="">
                                        <img class="hover-icon" src="<?php echo e(asset('assets/front/new/icon/signin-hover.svg')); ?>" alt="">
                                    </div>
                                    <span><?php echo e(read_lang_word('user-panel')); ?></span>
                                </a>
                                <div class="menu-dropdown">
                                    <div class="menu-dropdown-header">
                                        <a href="" class="dropdown-link">
                                            <?php echo e(Auth::user()->name); ?> <span class="gray-color"><?php echo e(read_lang_word('account')); ?></span>
                                        </a>
                                    </div>

                                    <a href="" class="dropdown-link">
                                        <?php echo e(read_lang_word('messages')); ?>

                                    </a>
                                    <a href="" class="dropdown-link">
                                        <?php echo e(read_lang_word('quotes')); ?>

                                    </a>
                                    <a href="" class="dropdown-link">
                                        <?php echo e(read_lang_word('favorites')); ?>

                                    </a>
                                    <a href="" class="dropdown-link">
                                        <?php echo e(read_lang_word('browsing-history')); ?>

                                    </a>

                                    <div class="menu-dropdown-footer">
                                        <a class="dropdown-link" href="javascript:void(0)" onclick="$('.logout').submit()">
                                            <span class="gray-color"><?php echo e(read_lang_word('sing-out')); ?></span>
                                            <form action="<?php echo e(route('logout')); ?>" method="POST" class="logout hidden"><?php echo e(csrf_field()); ?></form>
                                        </a>
                                    </div>
                                </div>
                            <?php else: ?>
                                <a href="#" class="header-button">
                                    <div class="icon-box">
                                        <img class="normal-icon" src="<?php echo e(asset('assets/front/new/icon/signin-normal.svg')); ?>" alt="">
                                        <img class="hover-icon" src="<?php echo e(asset('assets/front/new/icon/signin-hover.svg')); ?>" alt="">
                                    </div>
                                    <span><?php echo e(read_lang_word('sign-in')); ?></span>
                                </a>
                                <div class="menu-dropdown">
                                    <div class="menu-dropdown-header border-0 mb-0">
                                        <a href="<?php echo e(route('front.loginnew')); ?>" class="default-button w-100">
                                            <?php echo e(read_lang_word('sign-in-with-email')); ?>

                                        </a>
                                    </div>

                                    <div class="social-divider">
                                        <span><?php echo e(read_lang_word('or-sign-in-with')); ?></span>
                                    </div>

                                    <div class="menu-dropdown-footer border-0 mt-0">
                                        <div class="d-flex justify-content-around">
                                            <a href="" class="social-icon google" title="Google">
                                                <i class="fab fa-google"></i>
                                            </a>
                                            <a href="" class="social-icon facebook" title="Facebook">
                                                <i class="fab fa-facebook"></i>
                                            </a>
                                            <a href="" class="social-icon linkedin" title="LinkedIn">
                                                <i class="fab fa-linkedin"></i>
                                            </a>
                                            <a href="" class="social-icon twitter" title="X">
                                                <i class="fab fa-twitter"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </li>
                        <li class="d-md-flex d-none stiky-none">
                            <?php if(Auth::check()): ?>
                                <a href="#" class="header-button">
                                    <div class="icon-box">
                                        <img class="normal-icon" src="<?php echo e(asset('assets/front/new/icon/messages-normal.svg')); ?>" alt="">
                                        <img class="hover-icon" src="<?php echo e(asset('assets/front/new/icon/messages-hover.svg')); ?>" alt="">
                                    </div>
                                    <span>Messages</span>
                                </a>
                                <div class="menu-dropdown">
                                    <a href="" class="dropdown-link">
                                        Inquiries
                                    </a>
                                    <a href="" class="dropdown-link">
                                        Request For quotation
                                    </a>
                                    <a href="" class="dropdown-link">
                                        Notifications
                                    </a>
                                    <a href="" class="dropdown-link">
                                        Chats
                                    </a>
                                </div>
                            <?php else: ?>
                                <a href="#" class="header-button">
                                    <div class="icon-box">
                                        <img class="normal-icon" src="<?php echo e(asset('assets/front/new/icon/messages-normal.svg')); ?>" alt="">
                                        <img class="hover-icon" src="<?php echo e(asset('assets/front/new/icon/messages-hover.svg')); ?>" alt="">
                                    </div>
                                    <span>Messages</span>
                                </a>
                                <div class="menu-dropdown">
                                    <span class="menu-dropdown-message">Please Sign In To See Your Messages And Notifications.</span>
                                </div>
                            <?php endif; ?>
                        </li>
                        <?php if(Auth::check()): ?>
                            <li class="d-md-flex d-none stiky-none">
                                <a href="#" class="header-button">
                                    <div class="icon-box">
                                        <img class="normal-icon" src="<?php echo e(asset('assets/front/new/icon/favorits-normal.svg')); ?>" alt="">
                                        <img class="hover-icon" src="<?php echo e(asset('assets/front/new/icon/favorits-hover.svg')); ?>" alt="">
                                    </div>
                                    <span>Favorites</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <li class="flex stiky-on">
                            <a href="<?php echo e(route('rfq')); ?>" class="default-button border header-button">
                                <div class="icon-box">
                                    <img class="normal-icon" src="<?php echo e(asset('assets/front/new/icon/rfq-normal.svg')); ?>" alt="">
                                    <img class="hover-icon" src="<?php echo e(asset('assets/front/new/icon/rfq-hover.svg')); ?>" alt="">
                                </div>
                                <span><?php echo e(read_lang_word('post-my-rfq')); ?></span>
                            </a>
                            <div class="menu-dropdown">
                                <span class="menu-dropdown-message">Tell Us What You Need, Get Multiple Quotes.</span>
                            </div>
                        </li>
                        <?php if(!auth()->user()): ?>
                            <li class="flex d-md-flex d-none">
                                <a href="<?php echo e(route('front.signupnew')); ?>" class="default-button" hover-txt="<?php echo e(read_lang_word('join-free-hover')); ?>">
                                    <?php echo e(read_lang_word('join-free')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <li class="flex d-lg-none d-flex">
                            <div class="hamburger-button" data-bs-toggle="modal" data-bs-target="#mobileMenuNavigation">
                                <span class="top"></span>
                                <span class="mid"></span>
                                <span class="bot"></span>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Header Bottom Side -->
    <div class="header-navigation d-none d-xl-flex">
        <div class="container-xxl d-flex justify-content-between align-items-center flex-wrap">

            <ul class="navigation-list">
                <li class="navigation-item primary">
                    <a href="#">Smart Expo</a>
                </li>
                <li class="navigation-item">
                    <a href="#">Categories</a>
                </li>
                <li class="navigation-item">
                    <a href="#">Buyers</a>
                </li>
                <li class="navigation-item">
                    <a href="#">Suppliers</a>
                </li>
                <li class="navigation-item">
                    <a href="#">Products Search</a>
                </li>
                <li class="navigation-item">
                    <a href="#">Verified Suppliers</a>
                </li>
                <li class="navigation-item">
                    <a href="#">Online Tradeshow</a>
                </li>
            </ul>

            <ul class="navigation-list">
                <li class="navigation-item">
                    <a href="#">Apps&#9662;</a>
                    <div class="menu-dropdown">
                        <span class="menu-dropdown-message">
                            <img class="qr" src="<?php echo e(asset('assets/front/new/images/qr.png')); ?>" alt="">
                        </span>
                    </div>
                </li>
                <li class="navigation-item">
                    <a href="#">Learning Center</a>
                </li>
                <li class="navigation-item">
                    <a href="#">Support</a>
                </li>
                <li class="navigation-item">
                    <a href="#">Help</a>
                </li>
                <div class="language-select-box">
                    <!-- Active Website Language -->
                    <span class="languages-item"> <?php echo e(strtoupper(site_lang()->lang)); ?>&#9662;</span>

                    <!-- Website Languages List -->
                    <ul>
                        <?php $__currentLoopData = menu_langs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e(LaravelLocalization::getLocalizedURL($lang->lang, null, [], true)); ?>" class="languages-item"> <?php echo e(strtoupper($lang->lang)); ?> </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </ul>

        </div>
    </div>
</header>
<?php /**PATH /home/nexpo/public_html/new/source/resources/views/front/layouts/includes_front/header.blade.php ENDPATH**/ ?>