

<?php $__env->startSection('content'); ?>
    <style>
        .count_badge
        {
            position: absolute;
            right: -15px;
            top: -20px;
        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        <?php echo e($title); ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_create')): ?>
                        <a href="<?php echo e(route('admin.product.create')); ?>" class="btn btn-primary float-left"><?php echo e(translateText('افزودن محصول',lang_admin())); ?></a>
                        <?php endif; ?>
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-wrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0"><?php echo e(translateText('نام محصول',lang_admin())); ?></th>
                                <th class="border-bottom-0"><?php echo e(translateText('دسته بندی',lang_admin())); ?></th>
                                <th class="border-bottom-0"><?php echo e(translateText('قیمت',lang_admin())); ?></th>
                                <th class="border-bottom-0"><?php echo e(translateText('تصویر',lang_admin())); ?></th>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['product_edit','product_delete','product_other'])): ?>
                                <th class="border-bottom-0"><?php echo e(translateText('عملیات',lang_admin())); ?></th>
                                <?php endif; ?>    
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key+1); ?></td>
                                    <td>
                                       <?php echo e($item->title); ?>

                                        <?php if(!auth()->user()->hasRole('supplier') && $item->user): ?>
                                            <br/>
                                            <span class="badge badge-danger"><?php echo e($item->user->name); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td dir="ltr">
                                        <?php if($item->c1): ?>
                                            <span class="badge badge-info mb-1"><?php echo e($item->c1->title); ?></span>
                                            <br/>
                                        <?php endif; ?>
                                        <?php if($item->c2): ?>
                                            <span class="badge badge-info mb-1"><?php echo e($item->c2->title); ?></span>
                                            <br/>
                                        <?php endif; ?>
                                        <?php if($item->c3): ?>
                                            <span class="badge badge-info mb-1"><?php echo e($item->c3->title); ?></span>
                                            <br/>
                                        <?php endif; ?>
                                        <?php if($item->c4): ?>
                                            <span class="badge badge-info"><?php echo e($item->c4->title); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td dir="ltr" class="text-nowrap">
                                        <?php if(count($item->prices)): ?>
                                            From:
                                       <?php echo e($item->prices[0]->price); ?>

                                        <small>$</small>
                                            <br/>
                                        To:
                                            <?php echo e($item->price_last->price); ?>

                                            <small>$</small>
                                        <?php else: ?>
                                            __
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($item->photo && is_file($item->photo->path)): ?>
                                            <img src="<?php echo e(url($item->photo->path)); ?>" height="100px" width="100px" style="object-fit: contain">
                                        <?php else: ?>
                                            __
                                        <?php endif; ?>
                                    </td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['product_edit','product_delete','product_other'])): ?>
                                        <td>
                                            <div class="d-flex">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_other')): ?>
                                                    <a href="<?php echo e(route('admin.product.price',$item->id)); ?>"
                                                       class="action-btns1 position-relative">
                                                        <i class="feather feather-dollar-sign  text-warning"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="<?php echo e(translateText('قیمت ها',lang_admin())); ?>"></i>
                                                        <span class="badge badge-danger count_badge"><?php echo e(count($item->prices)); ?></span>
                                                    </a>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_other')): ?>
                                                    <a href="<?php echo e(route('admin.product.feature',$item->id)); ?>"
                                                       class="action-btns1 position-relative">
                                                        <i class="feather feather-share-2  text-info"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="<?php echo e(translateText('ویژگی ها',lang_admin())); ?>"></i>
                                                        <span class="badge badge-danger count_badge"><?php echo e(count($item->features)); ?></span>
                                                    </a>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_edit')): ?>
                                                    <a href="<?php echo e(route('admin.product.edit',$item->id)); ?>"
                                                       class="action-btns1">
                                                        <i class="feather feather-edit-2  text-success"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="<?php echo e(translateText('ویرایش',lang_admin())); ?>"></i>
                                                    </a>
                                                <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_delete')): ?>
                                                    <?php echo Form::open(['method' => 'DELETE', 'route' => ['admin.product.destroy', $item->id] ]); ?>

                                                    <button class="action-btns1" data-toggle="tooltip"
                                                            data-placement="top" title="<?php echo e(translateText('حذف',lang_admin())); ?>"
                                                            onclick="return confirm('<?php echo e(translateText('برای حذف مطمئن هستید؟',lang_admin())); ?>')">
                                                        <i class="feather feather-trash-2 text-danger"></i>
                                                    </button>
                                                    <?php echo Form::close(); ?>

                                                    <?php endif; ?>
                                            </div>
                                        </td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app',['tbl'=>true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexpo/public_html/new/source/resources/views/admin/product/index.blade.php ENDPATH**/ ?>