<div class="col-md-6 order-xl-2 order-md-3 box-ord-2">
    <div class="card monthly-header shadow-sm">
        <div class="card-header border-0 bg-white">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-semibold"><?php echo e(translateText('Profile Overview', lang_admin())); ?></h5>
                <div class="card-header-right-icon">
                    <i class="fas fa-user"></i>
                </div>
            </div>
        </div>
        <div class="card-body pt-3 px-4">
            <div class="d-flex align-items-center flex-wrap p-3 rounded-3 mb-3">
                <div class="me-3">
                    <img src="<?php echo e($profilePhoto); ?>" alt="<?php echo e(translateText('Profile Photo', lang_admin())); ?>" class="rounded-circle border border-2 border-primary" style="width: 90px; height: 90px; object-fit: cover;">
                </div>
                <div class="flex-grow-1">
                    <h6 class="mb-1 fw-bold"><?php echo e(translateText('Welcome', lang_admin())); ?> <?php echo e($companyName); ?>!</h6>
                    <!--[if BLOCK]><![endif]--><?php if($countryFlag): ?>
                        <span style="font-size: 24px;">
                            <?php echo e($countryFlag); ?>

                        </span>
                        <span class="text-muted"><?php echo e($countryName); ?></span>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
            <div class="p-3">
                <div class="mb-4 d-flex align-items-center">
                    <span class="text-muted me-2"><?php echo e(translateText('Membership Type', lang_admin())); ?>:</span>
                    <span class="fw-semibold text-dark"><?php echo e($membershipType); ?></span>
                    <a href="#" class="btn btn-sm btn-primary ms-auto rounded-pill px-3"><?php echo e(translateText('Upgrade Now', lang_admin())); ?></a>
                </div>
                <div class="mb-4">
                    <div class="d-flex align-items-center mb-2">
                        <span class="text-muted me-2"><?php echo e(translateText('Account Type', lang_admin())); ?>:</span>
                        <span class="fw-semibold text-dark"><?php echo e($accountType); ?></span>
                    </div>
                    <div class="mt-2 d-flex gap-2">
                        <a href="#" class="btn btn-sm btn-primary rounded-pill"><?php echo e(translateText('Create Buyer Account', lang_admin())); ?></a>
                        <a href="#" class="btn btn-sm btn-primary rounded-pill"><?php echo e(translateText('Add Service Provider', lang_admin())); ?></a>
                    </div>
                </div>
                <div class="mb-4 d-flex align-items-center">
                    <span class="text-muted me-2"><?php echo e(translateText('Member Since', lang_admin())); ?>:</span>
                    <span class="fw-semibold text-dark"><?php echo e($memberSince); ?></span>
                </div>
                <div class="mb-4 d-flex align-items-center">
                    <span class="text-muted me-2"><?php echo e(translateText('Email Address', lang_admin())); ?>:</span>
                    <span class="fw-semibold text-dark"><?php echo e($email); ?></span>
                </div>
                <div class="mb-4 d-flex align-items-center">
                    <span class="text-muted me-2"><?php echo e(translateText('Phone Number', lang_admin())); ?>:</span>
                    <span class="fw-semibold text-dark">+<?php echo e($phoneNumber); ?></span>
                </div>
                <div class="mb-0 d-flex align-items-center">
                    <span class="text-muted me-2"><?php echo e(translateText('Company Address', lang_admin())); ?>:</span>
                    <span class="fw-semibold text-dark"><?php echo e($companyAddress); ?></span>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
    <style>

    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<?php $__env->stopPush(); ?><?php /**PATH /home/nexpo/public_html/new/source/resources/views/livewire/dashboard/user-dashboard/profile-view.blade.php ENDPATH**/ ?>