<!-- Modal -->
<div class="modal fade" id="certificateModal<?php echo e($item->id); ?>" tabindex="-1" role="dialog"  aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(translateText('مجوزها/گواهینامه',lang_admin())); ?>  <?php echo e($item->name); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-6">
                            <p>
                                <strong><?php echo e(translateText('نام',lang_admin())); ?> : </strong>
                                <span><?php echo e($item->name?$item->name:'__'); ?></span>
                            </p>
                            <hr/>
                        </div>
                        <div class="col-md-6">
                            <p>
                                <strong><?php echo e(translateText('نام کاربری/ایمیل',lang_admin())); ?> : </strong>
                                <span dir="<?php echo e($item->username?'ltr':'rtl'); ?>"><?php echo e($item->username?$item->username:'__'); ?></span>
                            </p>
                            <hr/>
                        </div>
                        <div class="col-md-6">
                            <p>
                                <strong><?php echo e(translateText('شماره همراه',lang_admin())); ?> : </strong>
                                <span dir="<?php echo e($item->mobile?'ltr':'rtl'); ?>"><?php echo e($item->mobile?$item->country_code.'-'.$item->mobile:'__'); ?></span>
                            </p>
                            <hr/>
                        </div>
                        <div class="col-md-12">
                            <p>
                                <strong><?php echo e(translateText('نوع کسب وکار',lang_admin())); ?> : </strong>
                                <?php if(count($item->user_business)): ?>
                                    <span>
                                                                                                <?php $__currentLoopData = $item->user_business; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$business): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($key > 0 ? ', ':''); ?>

                                            <?php echo e($business->title); ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                            </span>
                                <?php else: ?>
                                    <span>__</span>
                                <?php endif; ?>
                            </p>
                            <hr/>
                        </div>
                        <div class="col-md-6">
                            <p>
                                <strong><?php echo e(translateText('فرکانس خرید',lang_admin())); ?> : </strong>
                                <span><?php echo e($item->user_purchasing?$item->user_purchasing->title:'__'); ?></span>
                            </p>
                            <hr/>
                        </div>
                        <div class="col-md-6">
                            <p>
                                <strong><?php echo e(translateText('حجم خرید سالیانه',lang_admin())); ?> : </strong>
                                <span><?php echo e($item->user_volume?$item->user_volume->title:'__'); ?></span>
                            </p>
                            <hr/>
                        </div>
                        <?php if($item->hasRole('supplier')): ?>
                        <div class="col-12" style="overflow-x: auto">
                            <p>
                                <strong><?php echo e(translateText('آدرس',lang_admin())); ?>: </strong>
                            </p>
                            <?php if(count($item->addresses)): ?>
                                <table class="table table-striped w-100">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(translateText('نام(شرکت/کارخانه)',lang_admin())); ?></th>
                                        <th><?php echo e(translateText('تماس',lang_admin())); ?></th>
                                        <th><?php echo e(translateText('کشور',lang_admin())); ?></th>
                                        <th><?php echo e(translateText('آدرس',lang_admin())); ?></th>
                                        <th>Zip Code</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $item->addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row"><?php echo e($key + 1); ?></th>
                                            <td><?php echo e($address->full_name); ?></td>
                                            <td dir="ltr">
                                                <?php echo e(translateText('Phone:',lang_admin())); ?>

                                                <span dir="ltr"
                                                      class="text-danger"><?php echo e($address->phone); ?></span>
                                                <br>
                                                <?php echo e(translateText('Fax:',lang_admin())); ?>

                                                <span dir="ltr" class="text-danger"><?php echo e($address->fax); ?></span>
                                                <br>
                                                <?php echo e(translateText('Mobile:',lang_admin())); ?>

                                                <span dir="ltr"
                                                      class="text-danger"><?php echo e($address->mobile); ?></span>
                                                <br>
                                                <?php echo e(translateText('Email:',lang_admin())); ?>

                                                <span dir="ltr"
                                                      class="text-danger"><?php echo e($address->email); ?></span>
                                            </td>
                                            <td><?php echo e($address->country ? $address->country->nicename : '__'); ?></td>
                                            <td>
                                                <?php echo e($address->state); ?>/<?php echo e($address->city); ?>

                                                <br/>
                                                <?php echo e($address->address); ?>

                                            </td>
                                            <td><?php echo e($address->zip_code); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            <?php else: ?>
                                <div class="alert alert-danger col-12 py-3">
                                    <?php echo e(translateText('آدرسی ثبت نشده',lang_admin())); ?>

                                </div>
                            <?php endif; ?>
                            <hr/>
                        </div>
                        <?php endif; ?>
                        <?php if($item->user_type == 'legal'): ?>
                        <div class="col-12" style="overflow-x: auto">
                            <p>
                                <strong><?php echo e(translateText('گواهینامه ها',lang_admin())); ?> : </strong>
                            </p>
                            <?php if(count($item->certificates)): ?>
                                <table class="table table-striped w-100">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(translateText('نوع سند',lang_admin())); ?></th>
                                        <th><?php echo e(translateText('نوع گواهینامه',lang_admin())); ?></th>
                                        <th>Tax Id/License Id</th>
                                        <th><?php echo e(translateText('تصویر',lang_admin())); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $item->certificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$certificate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row"><?php echo e($key + 1); ?></th>
                                            <td><?php echo e($certificate->get_type_title()); ?></td>
                                            <td><?php echo e($certificate->select_type ? $certificate->select_type->title : '__'); ?></td>
                                            <td><?php echo e(!blank($certificate->tax_id) ? $certificate->tax_id : '__'); ?></td>
                                            <td>
                                                <?php if($certificate->photo): ?>
                                                    <a href="<?php echo e(url($certificate->photo->path)); ?>"
                                                       target="_blank">
                                                        Show
                                                    </a>
                                                <?php else: ?>
                                                    __
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            <?php else: ?>
                                <div class="alert alert-danger col-12 py-3">
                                    <?php echo e(translateText('گواهینامه ای ثبت نشده',lang_admin())); ?>

                                </div>
                            <?php endif; ?>
                            <hr/>
                        </div>
                        <?php endif; ?>
                        <?php if($item->hasRole('buyer')): ?>
                        <div class="col-12" style="overflow-x: auto">
                            <p>
                                <strong><?php echo e(translateText('Passport',lang_admin())); ?> : </strong>
                            </p>
                            <?php if($item->passport): ?>
                                <table class="table table-striped w-100">
                                    <thead>
                                    <tr>
                                        <th><?php echo e(translateText('Passport Number',lang_admin())); ?></th>
                                        <th><?php echo e(translateText('تصویر',lang_admin())); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td><?php echo e($item->passport->tax_id); ?></td>
                                            <td>
                                                <?php if($item->passport->photo): ?>
                                                    <a href="<?php echo e(url($item->passport->photo->path)); ?>"
                                                       target="_blank">
                                                        Show
                                                    </a>
                                                <?php else: ?>
                                                    __
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            <?php else: ?>
                                <div class="alert alert-danger col-12 py-3">
                                    <?php echo e(translateText('گذرنامه ای ثبت نشده',lang_admin())); ?>

                                </div>
                            <?php endif; ?>
                            <hr/>
                        </div>
                            <div class="col-12" style="overflow-x: auto">
                                <p>
                                    <strong><?php echo e(translateText('National ID Card',lang_admin())); ?> : </strong>
                                </p>
                                <?php if($item->n_cart): ?>
                                    <table class="table table-striped w-100">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(translateText('National ID Card Number',lang_admin())); ?></th>
                                            <th><?php echo e(translateText('تصویر',lang_admin())); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><?php echo e($item->n_cart->tax_id); ?></td>
                                            <td>
                                                <?php if($item->n_cart->photo): ?>
                                                    <a href="<?php echo e(url($item->n_cart->photo->path)); ?>"
                                                       target="_blank">
                                                        Show
                                                    </a>
                                                <?php else: ?>
                                                    __
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                <?php else: ?>
                                    <div class="alert alert-danger col-12 py-3">
                                        <?php echo e(translateText('گذرنامه ای ثبت نشده',lang_admin())); ?>

                                    </div>
                                <?php endif; ?>
                                <hr/>
                            </div>
                        <?php endif; ?>
                        <?php if(count($item->gallery)): ?>
                            <div class="col-12" style="overflow-x: auto">
                                <p>
                                    <strong><?php echo e(translateText('گالری تصایر/ویدئو',lang_admin())); ?> : </strong>
                                </p>
                                <table class="table table-striped w-100">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(translateText('عنوان گالری',lang_admin())); ?></th>
                                        <th><?php echo e(translateText('تصاویر/ویدئو',lang_admin())); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $item->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row"><?php echo e($key + 1); ?></th>
                                            <td><?php echo e($gallery->title); ?></td>
                                            <td>
                                                <?php if($gallery->photo): ?>
                                                    <a href="<?php echo e(url($gallery->photo->path)); ?>" data-fancybox="gallery_<?php echo e($gallery->id); ?>_<?php echo e($item->id); ?>">
                                                        <img src="<?php echo e(url($gallery->photo->path)); ?>" height="100px">
                                                    </a>
                                                    <?php $__currentLoopData = $gallery->galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <a href="<?php echo e(url($photo->file)); ?>" class="d-none" data-fancybox="gallery_<?php echo e($gallery->id); ?>_<?php echo e($item->id); ?>"></a>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <?php $__currentLoopData = $gallery->galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keyy=>$photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <a href="<?php echo e(url($photo->file)); ?>" class="<?php echo e($keyy > 0 ? 'd-none' : ''); ?>" data-fancybox="gallery_<?php echo e($gallery->id); ?>_<?php echo e($item->id); ?>">نمایش گالری</a>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                                <hr/>
                            </div>
                        <?php endif; ?>
                        <div class="col-12">
                            <?php echo $item->info; ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/nexpo/public_html/new/source/resources/views/admin/user/include/modal.blade.php ENDPATH**/ ?>